<?php
/**
 * Template part for displaying page content in page-services.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package webinfy
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
<header class="banner-heading">
	<h2 class="left"><?php the_title(); ?></h2>
	<div class="banner-nav right">
		<ul>
			<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>">Home</a></li>
			<li><?php the_title(); ?></li>
		</ul>
	</div>
<div class="clear"></div>
</header>
<section class="section clear">
	<section class="section-content services clear">
    	<ul>
			<?php $fields = CFS()->get( 'services' ); foreach ( $fields as $field ) { ?>
        	<li>
            	<figcaption>
                    <figure><img src="<?php echo $field['services_icon']; ?>" /></figure>
                    <h3><?php echo $field['services_title']; ?></h3>
                </figcaption>
            </li>
			<?php } ?>
        </ul>
    </section>
</section>
</article><!-- #post-<?php the_ID(); ?> -->
