<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package webinfy
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="send-enquiry" class="modal">
	<div class="send-enquiry">
    <span class="close">&times;</span>
    	<fieldset class="clear">
    	<?php echo do_shortcode('[contact-form-7 id="41" title="Send Enquiry"]');?>
        </fieldset>
	</div>
</div>
<div id="page" class="site">
	<header class="header-top clear">
    <header id="masthead" class="site-header clear">
		<div class="site-branding left">
			<?php
			the_custom_logo();
			if ( is_front_page() && is_home() ) :
				?>
				<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
				<?php
			else :
				?>
				<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
				<?php
			endif;
			$webinfy_description = get_bloginfo( 'description', 'display' );
			if ( $webinfy_description || is_customize_preview() ) :
				?>
				<p class="site-description"><?php echo $webinfy_description; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></p>
			<?php endif; ?>
		</div><!-- .site-branding -->
		<div class="search-box left">
			<?php dynamic_sidebar('search_header') ?>
        </div>
		<div class="phone-header right">
			<?php dynamic_sidebar('header_phone_no') ?>
        </div>
	</header><!-- #masthead -->
    <div class="navbar clear">
		<nav id="site-navigation" class="main-navigation left">
			<button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false">
				<div onclick="myFunction(this)">
					<div class="bar1"></div>
					<div class="bar2"></div>
					<div class="bar3"></div>
				</div>
			</button>
			<?php
			wp_nav_menu(
				array(
					'theme_location' => 'menu-1',
					'menu_id'        => 'primary-menu',
				)
			);
			?>
		</nav>
		<aside class="right">
			<?php
			wp_nav_menu(
				array(
					'theme_location' => 'menu-2',
					'menu_id'        => 'nav-side-menu',
				)
			);
			?>
		</aside>
    </div>
    </header>
