<?php
/**
 * Template part for displaying page content in page-products.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package webinfy
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
<header class="banner-heading">
	<h2 class="left"><?php the_title(); ?></h2>
	<div class="banner-nav right">
		<ul>
			<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>">Home</a></li>
			<li><?php the_title(); ?></li>
		</ul>
	</div>
<div class="clear"></div>
</header>
<section class="section clear">
	<section class="section-products products clear">
    	<aside class="sidebar left">
			<?php get_sidebar(); ?>
            <h2>Categories</h2>
            <ul class="categories">
            <?php wp_list_categories( array(
                        'orderby' => 'name',
                        'taxonomy' => 'products',
                        'depth' => 1,
                        'title_li' => '',
                        'hide_title_if_empty' => true,
                        'use_desc_for_title'  => 0,
                        ///'include' => array( 28, 27, 8, 29, 43, 31 )
                    ) ); ?>
            </ul>
		</aside>
    	<aside class="content right">
			<?php $args = array(
		'post_type'   => 'products',	  
		'showposts' => 20,
		'orderby' => 'date',
			'tax_query' => array(
				array(
					'taxonomy' => 'products',
					'field' => 'slug',
					'terms' => 'todays-top-deals'
				)
			)
		);
	query_posts($args); if (have_posts()): ?>
    <section class="product-carousel clear">
    	<article class="clear">
        	<h2 class="left"><?php single_cat_title(); ?></h2>
            <a href="" class="right">View All</a>
        </article>
	  	<div class="products-slider-inner owl-carousel owl-theme">
			<?php while (have_posts()): the_post(); ?>
        	<div class="item">
				<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                    <figure>
                        <?php $src = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), array( 1800,820 ), false, '' ); ?>
						<img src="<?php echo $src[0]; ?>" />
                    </figure>
					<div class="offer"><?php echo CFS()->get( 'product_offers' ); ?></div>
					<span>More Details</span>
                    <figcaption>
                        <h3><?php the_title(); ?></h3>
                    </figcaption>
                </a>
				<button class="button" data-modal="send-enquiry"><i class="fa fa-envelope"></i></button>
            </div>
			<?php endwhile; ?>
	  	</div>
    </section>
<?php endif; wp_reset_query(); ?>
<?php $args = array(
		'post_type'   => 'products',	  
		'showposts' => 20,
		'orderby' => 'date',
			'tax_query' => array(
				array(
					'taxonomy' => 'products',
					'field' => 'slug',
					'terms' => 'laptops'
				)
			)
		);
	query_posts($args); if (have_posts()): ?>
    <section class="product-carousel product-carousel-top-margin clear">
    	<article class="clear">
        	<h2 class="left"><?php single_cat_title(); ?></h2>
            <a href="<?php echo get_category_link( $category_id ); ?>" class="right">View All</a>
        </article>
	  	<div class="products-slider-inner owl-carousel owl-theme">
			<?php while (have_posts()): the_post(); ?>
        	<div class="item">
				<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                    <figure>
                        <?php $src = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), array( 1800,820 ), false, '' ); ?>
						<img src="<?php echo $src[0]; ?>" />
                    </figure>
					<div class="offer"><?php echo CFS()->get( 'product_offers' ); ?></div>
					<span>More Details</span>
                    <figcaption>
                        <h3><?php the_title(); ?></h3>
                    </figcaption>
                </a>
				<button class="button" data-modal="send-enquiry"><i class="fa fa-envelope"></i></button>
            </div>
			<?php endwhile; ?>
	  	</div>
    </section>
<?php endif; wp_reset_query(); ?>
<?php $args = array(
		'post_type'   => 'products',	  
		'showposts' => 20,
		'orderby' => 'date',
			'tax_query' => array(
				array(
					'taxonomy' => 'products',
					'field' => 'slug',
					'terms' => 'desktops'
				)
			)
		);
	query_posts($args); if (have_posts()): ?>
    <section class="product-carousel product-carousel-top-margin clear">
    	<article class="clear">
        	<h2 class="left"><?php single_cat_title(); ?></h2>
            <a href="<?php echo get_category_link( $category_id ); ?>" class="right">View All</a>
        </article>
	  	<div class="products-slider-inner owl-carousel owl-theme">
			<?php while (have_posts()): the_post(); ?>
        	<div class="item">
				<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                    <figure>
                        <?php $src = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), array( 1800,820 ), false, '' ); ?>
						<img src="<?php echo $src[0]; ?>" />
                    </figure>
					<div class="offer"><?php echo CFS()->get( 'product_offers' ); ?></div>
					<span>More Details</span>
                    <figcaption>
                        <h3><?php the_title(); ?></h3>
                    </figcaption>
                </a>
				<button class="button" data-modal="send-enquiry"><i class="fa fa-envelope"></i></button>
            </div>
			<?php endwhile; ?>
	  	</div>
    </section>
<?php endif; wp_reset_query(); ?>
<?php $args = array(
		'post_type'   => 'products',	  
		'showposts' => 20,
		'orderby' => 'date',
			'tax_query' => array(
				array(
					'taxonomy' => 'products',
					'field' => 'slug',
					'terms' => 'accessories'
				)
			)
		);
	query_posts($args); if (have_posts()): ?>
    <section class="product-carousel product-carousel-top-margin clear">
    	<article class="clear">
        	<h2 class="left"><?php single_cat_title(); ?></h2>
            <a href="<?php echo get_category_link( $category_id ); ?>" class="right">View All</a>
        </article>
	  	<div class="products-slider-inner owl-carousel owl-theme">
			<?php while (have_posts()): the_post(); ?>
        	<div class="item">
				<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                    <figure>
                        <?php $src = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), array( 1800,820 ), false, '' ); ?>
						<img src="<?php echo $src[0]; ?>" />
                    </figure>
					<div class="offer"><?php echo CFS()->get( 'product_offers' ); ?></div>
					<span>More Details</span>
                    <figcaption>
                        <h3><?php the_title(); ?></h3>
                    </figcaption>
                </a>
				<button class="button" data-modal="send-enquiry"><i class="fa fa-envelope"></i></button>
            </div>
			<?php endwhile; ?>
	  	</div>
    </section>
<?php endif; wp_reset_query(); ?>
		</aside>
    </section>
</section>
</article><!-- #post-<?php the_ID(); ?> -->
