<?php
/**
 * Template part for displaying page content in page-home.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package webinfy
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
<?php $args = array(
		'post_type'   => 'sliders',	  
		'showposts' => 10,
		'orderby' => 'date',
			'tax_query' => array(
				array(
					'taxonomy' => 'sliders',
					'field' => 'slug',
					'terms' => 'home-slider'
				)
			)
		);
	query_posts($args); if (have_posts()): ?>
<header class="banner clear">
	<div class="container">
        <div id="slick">
		<?php while (have_posts()): the_post(); ?>
		<?php $src = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), array( 1800,820 ), false, '' ); ?>
			<div class="img--holder hero slide--has-caption"><img src="<?php echo $src[0]; ?>" /></div>
		<?php endwhile; ?>
        </div>
	</div>
<?php endif; wp_reset_query(); ?>
</header>
<section class="section clear">
<?php $args = array(
		'post_type'   => 'products',	  
		'showposts' => 20,
		'orderby' => 'date',
			'tax_query' => array(
				array(
					'taxonomy' => 'products',
					'field' => 'slug',
					'terms' => 'todays-top-deals'
				)
			)
		);
	query_posts($args); if (have_posts()): ?>
    <section class="product-carousel clear">
    	<article class="clear">
        	<h2 class="left"><?php single_cat_title(); ?></h2>
            <a href="" class="right">View All</a>
        </article>
	  	<div class="products-slider owl-carousel owl-theme">
			<?php while (have_posts()): the_post(); ?>
        	<div class="item">
				<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                    <figure>
                        <?php $src = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), array( 1800,820 ), false, '' ); ?>
						<img src="<?php echo $src[0]; ?>" />
                    </figure>
					<div class="offer"><?php echo CFS()->get( 'product_offers' ); ?></div>
					<span>More Details</span>
                    <figcaption>
                        <h3><?php the_title(); ?></h3>
                    </figcaption>
                </a>
				<button class="button" data-modal="send-enquiry"><i class="fa fa-envelope"></i></button>
            </div>
			<?php endwhile; ?>
	  	</div>
    </section>
<?php endif; wp_reset_query(); ?>
    <section class="home-offers clear">
    	<ul>
			<?php $fields = CFS()->get( 'offers' ); foreach ( $fields as $field ) { ?>
        	<li><a href="#"><img src="<?php echo $field['offers_image']; ?>" /></a></li>
			<?php } ?>
        </ul>
    </section>
<?php $args = array(
		'post_type'   => 'products',	  
		'showposts' => 20,
		'orderby' => 'date',
			'tax_query' => array(
				array(
					'taxonomy' => 'products',
					'field' => 'slug',
					'terms' => 'laptops'
				)
			)
		);
	query_posts($args); if (have_posts()): ?>
    <section class="product-carousel product-carousel-top-margin clear">
    	<article class="clear">
        	<h2 class="left"><?php single_cat_title(); ?></h2>
            <a href="<?php echo get_category_link( $category_id ); ?>" class="right">View All</a>
        </article>
	  	<div class="products-slider owl-carousel owl-theme">
			<?php while (have_posts()): the_post(); ?>
        	<div class="item">
				<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                    <figure>
                        <?php $src = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), array( 1800,820 ), false, '' ); ?>
						<img src="<?php echo $src[0]; ?>" />
                    </figure>
					<div class="offer"><?php echo CFS()->get( 'product_offers' ); ?></div>
					<span>More Details</span>
                    <figcaption>
                        <h3><?php the_title(); ?></h3>
                    </figcaption>
                </a>
				<button class="button" data-modal="send-enquiry"><i class="fa fa-envelope"></i></button>
            </div>
			<?php endwhile; ?>
	  	</div>
    </section>
<?php endif; wp_reset_query(); ?>
<?php $args = array(
		'post_type'   => 'products',	  
		'showposts' => 20,
		'orderby' => 'date',
			'tax_query' => array(
				array(
					'taxonomy' => 'products',
					'field' => 'slug',
					'terms' => 'desktops'
				)
			)
		);
	query_posts($args); if (have_posts()): ?>
    <section class="product-carousel product-carousel-top-margin clear">
    	<article class="clear">
        	<h2 class="left"><?php single_cat_title(); ?></h2>
            <a href="<?php echo get_category_link( $category_id ); ?>" class="right">View All</a>
        </article>
	  	<div class="products-slider owl-carousel owl-theme">
			<?php while (have_posts()): the_post(); ?>
        	<div class="item">
				<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                    <figure>
                        <?php $src = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), array( 1800,820 ), false, '' ); ?>
						<img src="<?php echo $src[0]; ?>" />
                    </figure>
					<div class="offer"><?php echo CFS()->get( 'product_offers' ); ?></div>
					<span>More Details</span>
                    <figcaption>
                        <h3><?php the_title(); ?></h3>
                    </figcaption>
                </a>
				<button class="button" data-modal="send-enquiry"><i class="fa fa-envelope"></i></button>
            </div>
			<?php endwhile; ?>
	  	</div>
    </section>
<?php endif; wp_reset_query(); ?>
<?php $args = array(
		'post_type'   => 'products',	  
		'showposts' => 20,
		'orderby' => 'date',
			'tax_query' => array(
				array(
					'taxonomy' => 'products',
					'field' => 'slug',
					'terms' => 'accessories'
				)
			)
		);
	query_posts($args); if (have_posts()): ?>
    <section class="product-carousel product-carousel-top-margin clear">
    	<article class="clear">
        	<h2 class="left"><?php single_cat_title(); ?></h2>
            <a href="<?php echo get_category_link( $category_id ); ?>" class="right">View All</a>
        </article>
	  	<div class="products-slider owl-carousel owl-theme">
			<?php while (have_posts()): the_post(); ?>
        	<div class="item">
				<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
                    <figure>
                        <?php $src = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), array( 1800,820 ), false, '' ); ?>
						<img src="<?php echo $src[0]; ?>" />
                    </figure>
					<div class="offer"><?php echo CFS()->get( 'product_offers' ); ?></div>
					<span>More Details</span>
                    <figcaption>
                        <h3><?php the_title(); ?></h3>
                    </figcaption>
                </a>
				<button class="button" data-modal="send-enquiry"><i class="fa fa-envelope"></i></button>
            </div>
			<?php endwhile; ?>
	  	</div>
    </section>
<?php endif; wp_reset_query(); ?>
<?php $args = array(
		'post_type'   => 'products',	  
		'showposts' => 20,
		'orderby' => 'date',
			'tax_query' => array(
				array(
					'taxonomy' => 'products',
					'field' => 'slug',
					'terms' => 'recommended-products'
				)
			)
		);
	query_posts($args); if (have_posts()): ?>
    <section class="recommended-products clear">
		<h2><?php single_cat_title(); ?></h2>
        <ul>
			<?php while (have_posts()): the_post(); ?>
        	<li>
				<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
				<figure>
					<?php $src = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), array( 1800,820 ), false, '' ); ?>
					<img src="<?php echo $src[0]; ?>" />
				</figure>
				<figcaption>
					<h3><?php the_title(); ?></h3>
				</figcaption>
            </a>
			<button class="button" data-modal="send-enquiry">Send Enquiry</button>
            </li>
			<?php endwhile; ?>
        </ul>
    </section>
<?php endif; wp_reset_query(); ?>
    <section class="clients clear">
        <ul>
			<?php $fields = CFS()->get( 'clients' ); foreach ( $fields as $field ) { ?>
        	<li><figure><img src="<?php echo $field['clients_logo']; ?>" /></figure></li>
			<?php } ?>
        </ul>
    </section>
    <section class="tabs clear">
        <ul>
			<?php $fields = CFS()->get( 'tabs' ); foreach ( $fields as $field ) { ?>
        	<li>
                <img src="<?php echo $field['tabs_icon']; ?>" />
                <h3><?php echo $field['tabs_title']; ?></h3>
                <p><?php echo $field['tabs_content']; ?></p>
            </li>
			<?php } ?>
        </ul>
    </section>
</section>
</article><!-- #post-<?php the_ID(); ?> -->
