<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package webinfy
 */

get_header();
?>
<header class="banner-heading">
	<h2 class="left"><?php the_title(); ?></h2>
<div class="clear"></div>
</header>
<section class="section-content product-page clear">
	<article class="clear">
		<div class="product-image left">
			<?php $src = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), array( 1800,820 ), false, '' ); ?>
			<img id="imageZoom" src="<?php echo $src[0]; ?>" />
		</div>
		<div class="product-details right">
        	<div class="product-offers"><?php echo CFS()->get( 'product_offers' ); ?></div>
        	<h4><?php echo CFS()->get( 'brand_name' ); ?></h4>
        	<h3><?php the_title(); ?></h3>
            <h2><del><?php echo CFS()->get( 'product_mrp' ); ?></del><?php echo CFS()->get( 'product_offer_price' ); ?></h2>
			<button class="button" data-modal="send-enquiry">Send Enquiry</button>
		</div>
    </article>
</section>
<section class="product-spec clear">
	<h2>Product Specification</h2>
	<article class="clear">
		<?php if( get_field('product_specification') ): ?>
            <?php while( the_repeater_field('product_specification') ): ?>
                <p><strong><?php the_sub_field('product_specification_heading'); ?></strong><?php the_sub_field('product_specification_content'); ?></p>
            <?php endwhile; ?>
        <?php endif; ?>        
        <?php the_field('product_specification_text'); ?>
    </article>
</section>
<?php $args = array(
		'post_type'   => 'products',	  
		'showposts' => 20,
		'orderby' => 'date',
			'tax_query' => array(
				array(
					'taxonomy' => 'products',
					'field' => 'slug',
					'terms' => 'recommended-products'
				)
			)
		);
	query_posts($args); if (have_posts()): ?>
    <section class="recommended-products clear">
		<h2><?php single_cat_title(); ?></h2>
        <ul>
			<?php while (have_posts()): the_post(); ?>
        	<li>
				<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
				<figure>
					<?php $src = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), array( 1800,820 ), false, '' ); ?>
					<img src="<?php echo $src[0]; ?>" />
				</figure>
				<figcaption>
					<h3><?php the_title(); ?></h3>
				</figcaption>
            </a>
			<button class="button" data-modal="send-enquiry">Send Enquiry</button>
            </li>
			<?php endwhile; ?>
        </ul>
    </section>
<?php endif; wp_reset_query(); ?>

<?php
get_footer();
