<?php
/**
 * webinfy functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package webinfy
 */

if ( ! defined( '_S_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( '_S_VERSION', '1.0.0' );
}

if ( ! function_exists( 'webinfy_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function webinfy_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on webinfy, use a find and replace
		 * to change 'webinfy' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'webinfy', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(
			array(
				'menu-1' => esc_html__( 'Primary', 'webinfy' ),
				'menu-2' => esc_html__( 'Nav Side Menu', 'webinfy' ),
			)
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
			)
		);

		// Set up the WordPress core custom background feature.
		add_theme_support(
			'custom-background',
			apply_filters(
				'webinfy_custom_background_args',
				array(
					'default-color' => 'ffffff',
					'default-image' => '',
				)
			)
		);

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 250,
				'width'       => 250,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);
	}
endif;
add_action( 'after_setup_theme', 'webinfy_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function webinfy_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'webinfy_content_width', 640 );
}
add_action( 'after_setup_theme', 'webinfy_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function webinfy_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'webinfy' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'webinfy' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Search Header', 'webinfy' ),
			'id'            => 'search_header',
			'description'   => esc_html__( 'Add widgets here.', 'webinfy' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Header Phone No', 'webinfy' ),
			'id'            => 'header_phone_no',
			'description'   => esc_html__( 'Add widgets here.', 'webinfy' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer Top', 'webinfy' ),
			'id'            => 'footer_top',
			'description'   => esc_html__( 'Add widgets here.', 'webinfy' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer Information', 'webinfy' ),
			'id'            => 'footer_information',
			'description'   => esc_html__( 'Add widgets here.', 'webinfy' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer Reach Us', 'webinfy' ),
			'id'            => 'footer_reach_us',
			'description'   => esc_html__( 'Add widgets here.', 'webinfy' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer Contact Info', 'webinfy' ),
			'id'            => 'footer_contact_info',
			'description'   => esc_html__( 'Add widgets here.', 'webinfy' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer Follow Us', 'webinfy' ),
			'id'            => 'footer_follow_us',
			'description'   => esc_html__( 'Add widgets here.', 'webinfy' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'webinfy_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function webinfy_scripts() {
	wp_enqueue_style( 'webinfy-style', get_stylesheet_uri(), array(), _S_VERSION );
	wp_style_add_data( 'webinfy-style', 'rtl', 'replace' );
	wp_enqueue_style( 'webinfy-owl.carousel.min', get_template_directory_uri() . '/css/owl.carousel.min.css', array(),_S_VERSION, false );
	wp_enqueue_style( 'webinfy-owl.theme.default.min', get_template_directory_uri() . '/css/owl.theme.default.min.css', array(),_S_VERSION, false );
	wp_enqueue_style( 'webinfy-slick.min', get_template_directory_uri() . '/css/slick.min.css', array(),_S_VERSION, false );
	wp_enqueue_style( 'webinfy-slider', get_template_directory_uri() . '/css/slider.css', array(),_S_VERSION, false );

	wp_enqueue_script( 'webinfy-navigation', get_template_directory_uri() . '/js/navigation.js', array(), _S_VERSION, true );
	wp_enqueue_script( 'webinfy-jquery', get_template_directory_uri() . '/js/jquery.js', array(), _S_VERSION, true );
	wp_enqueue_script( 'webinfy-image-zoom', get_template_directory_uri() . '/js/image-zoom.js', array(), _S_VERSION, true );
	wp_enqueue_script( 'webinfy-device.min', get_template_directory_uri() . '/js/device.min.js', array(), _S_VERSION, true );
	wp_enqueue_script( 'webinfy-tmstickup', get_template_directory_uri() . '/js/tmstickup.js', array(), _S_VERSION, true );
	wp_enqueue_script( 'webinfy-jquery.easing', get_template_directory_uri() . '/js/jquery.easing.js', array(), _S_VERSION, true );
	wp_enqueue_script( 'webinfy-owl.carousel', get_template_directory_uri() . '/js/owl.carousel.js', array(), _S_VERSION, true );
	wp_enqueue_script( 'webinfy-script', get_template_directory_uri() . '/js/script.js', array(), _S_VERSION, true );
	wp_enqueue_script( 'webinfy-slick.min', get_template_directory_uri() . '/js/slick.min.js', array(), _S_VERSION, true );
	wp_enqueue_script( 'webinfy-slider', get_template_directory_uri() . '/js/slider.js', array(), _S_VERSION, true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'webinfy_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

/**
 *  Slider Taxonomy.
*/
add_action('init', 'sliders_register');
function sliders_register() {
	$labels = array(
		'name' => _x('Slider', 'movie type general name'),
		'singular_name' => _x('Slider', 'deail type singular name'),
		'add_new' => _x('Add New', 'Slider item'),
		'add_new_item' => __('Add New Slider Item'),
		'edit_item' => __('Edit Slider Item'),
		'new_item' => __('New Slider Item'),
		'view_item' => __('View Slider Item'),
		'search_items' => __('Search Slider'),
		'not_found' =>  __('Nothing found'),
		'not_found_in_trash' => __('Nothing found in Trash'),
		'parent_item_colon' => ''
	);

	$args = array(
		'labels' => $labels,
		'supports' => array( 'title', 'editor', 'thumbnail'),
		'public' => true,
		'publicly_queryable' => true,
		'show_ui' => true,
		'show_in_menu' => true,
		'query_var'  => true,
		'rewrite'    => array( 'slug' => 'sliders' ),
		'capability_type' => 'post',
		'hierarchical' => false,
		'menu_position' => null,
		'menu_icon'   => 'dashicons-images-alt2',
		'taxonomies' => array('sliders')
	  );

	//register what we just set up above
	register_post_type('sliders', $args);
}
register_taxonomy("sliders", array("slider"), array("hierarchical" => true, "label" => "Slider Categories", "singular_label" => "Slider Categories", "rewrite" => true, "show_in_nav_menus" => true));

/**
 *  Products.
*/
add_action('init', 'products_register');
function products_register() {
	$labels = array(
		'name' => _x('Products', 'movie type general name'),
		'singular_name' => _x('Products', 'deail type singular name'),
		'add_new' => _x('Add New', 'Products item'),
		'add_new_item' => __('Add New Products Item'),
		'edit_item' => __('Edit Products Item'),
		'new_item' => __('New Products Item'),
		'view_item' => __('View Products Item'),
		'search_items' => __('Search Products'),
		'not_found' =>  __('Nothing found'),
		'not_found_in_trash' => __('Nothing found in Trash'),
		'parent_item_colon' => ''
	);

	$args = array(
		'labels' => $labels,
		'supports' => array( 'title', 'editor', 'thumbnail'),
		'public' => true,
		'publicly_queryable' => true,
		'show_ui' => true,
		'show_in_menu' => true,
		'query_var'  => true,
		'rewrite'    => array( 'slug' => 'products' ),
		'capability_type' => 'post',
		'hierarchical' => false,
		'menu_position' => null,
		'menu_icon'   => 'dashicons-screenoptions',
		'taxonomies' => array('products')
	  );

	//register what we just set up above
	register_post_type('products', $args);
}
register_taxonomy("products", array("products"), array("hierarchical" => true, "label" => "Products Categories", "singular_label" => "Products Categories", "rewrite" => true, "show_in_nav_menus" => true));