(function($) {
	'use strict';

	function AysChartPlugin(element, options) {
		this.el = element;
		this.$el = $(element);
		this.htmlClassPrefix = 'ays-chart-';
		this.htmlNamePrefix = 'ays_';
		this.uniqueId;
		this.dbData = undefined;
		this.chartSourceData = undefined;
		this.chartObj = undefined;
		this.chartOptions = null;
		this.chartData = null;
		this.chartTempData = null;
	
		this.chartSources = {
			'line_chart'   : 'Line Chart',
			'bar_chart'    : 'Bar Chart',
			'pie_chart'    : 'Pie Chart',
			'column_chart' : 'Column Chart'
		}
	
		this.init();
	
		return this;
	}
	
	AysChartPlugin.prototype.init = function() {
		var _this = this;
		_this.uniqueId = _this.$el.data('id');

		if ( typeof window.aysChartOptions != 'undefined' ) {
            _this.dbData = JSON.parse( atob( window.aysChartOptions[ _this.uniqueId ] ) );
        }

		_this.setEvents();
	}
	
	AysChartPlugin.prototype.setEvents = function(e){
		var _this = this;
		
		var chartType = _this.dbData.chart_type;

		_this.loadChartBySource( chartType );
	}

	// Load charts by given type main function
	AysChartPlugin.prototype.loadChartBySource = function( chartType ){
		var _this = this;

		if( ! chartType ){
			chartType = _this.chartSourceData.chartType;
		}

		if(typeof chartType !== undefined && chartType){
			switch (chartType) {
				case 'pie_chart':
					_this.pieChartView( chartType );
					break;
				case 'bar_chart':
					_this.barChartView( chartType );
					break;
				case 'column_chart':
					_this.columnChartView( chartType );
					break;
				case 'line_chart':
					_this.lineChartView( chartType );
					break;
				default:
					_this.pieChartView( chartType );
					break;
			}
		}
	}

	// Load chart by pie chart
	AysChartPlugin.prototype.pieChartView = function( chartType ){
		var _this = this;
		var getChartSource = _this.dbData.source;

		var dataTypes = _this.chartConvertData( getChartSource );

		var settings = _this.dbData.options;
		var chartFontSize = settings['font_size'];
		var tooltipTrigger = settings['tooltip_trigger'];
		var tooltipText = settings['tooltip_text'];
		var showColorCode = (settings['show_color_code'] == 'on') ? true : false;
		var tooltipTextColor = settings['tooltip_text_color'];
		var legendPosition = settings['legend_position'];
		var legendAlignment = settings['legend_alignment'];
		var rotationDegree = settings['rotation_degree'];
		var sliceBorderColor = settings['slice_border_color'];
		var reverseCategories = (settings['reverse_categories'] == 'on') ? true : false;
		var legendColor = settings['legend_color'];
		var sliceText = settings['slice_text'];

		/* == Google part == */
		google.charts.load('current', {'packages':['corechart']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartData = google.visualization.arrayToDataTable( dataTypes );

			_this.chartOptions = {
				backgroundColor: 'transparent',
				chartArea: {
					width: '100%'
				},
				fontSize: chartFontSize,
				legend: {
					position: legendPosition,
					alignment: legendAlignment,
					textStyle: {
						color: legendColor
					}
				},
				tooltip: { 
					trigger: tooltipTrigger,
					showColorCode: showColorCode,
					text: tooltipText,
					textStyle: {
						color: tooltipTextColor
					}
				},
				pieStartAngle: rotationDegree,
				pieSliceBorderColor: sliceBorderColor,
				reverseCategories: reverseCategories,
				pieSliceText: sliceText
			};

			_this.chartObj = new google.visualization.PieChart( document.getElementById(_this.htmlClassPrefix + chartType + _this.uniqueId));

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}

	// Load chart by bar chart
	AysChartPlugin.prototype.barChartView = function( chartType ){
		var _this = this;
		var getChartSource = _this.dbData.source;
		var dataTypes = _this.multiColumnChartConvertData( getChartSource );

		var settings = _this.dbData.options;
		var chartFontSize = settings['font_size'];
		var tooltipTrigger = settings['tooltip_trigger'];
		var isStacked = (settings['is_stacked'] == 'on') ? true : false;
		var focusTarget = settings['focus_target'];
		var showColorCode = (settings['show_color_code'] == 'on') ? true : false;
		var tooltipTextColor = settings['tooltip_text_color'];
		var legendPosition = settings['legend_position'];
		var legendAlignment = settings['legend_alignment'];
		var legendColor = settings['legend_color'];
		var opacity = settings['opacity'];
		var hAxisTitle = settings['haxis_title'];
		var vAxisTitle = settings['vaxis_title'];
		var hAxisTextPosition = settings['haxis_text_position'];
		var vAxisTextPosition = settings['vaxis_text_position'];
		var vAxisDirection = (settings['vaxis_direction'] == '-1') ? -1 : 1;
		var hAxisDirection = (settings['haxis_direction'] == '-1') ? -1 : 1;
		var hAxisTextColor = settings['haxis_text_color'];
		var vAxisTextColor = settings['vaxis_text_color'];
		var hAxisSlantedText = settings['haxis_slanted'];
		var hAxisSlantedTextAngle = settings['haxis_slanted_text_angle'];

		var enableAnimation = (settings['enable_animation'] == 'on') ? true : false;
		var animationDuration = settings['animation_duration'];

		/* == Google part == */
		google.charts.load('current', {'packages':['corechart']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartData = google.visualization.arrayToDataTable(dataTypes);

			_this.chartOptions = {
				backgroundColor: 'transparent',
				fontSize: chartFontSize,
				legend: {
					position: legendPosition,
					alignment: legendAlignment,
					textStyle: {
						color: legendColor
					}
				},
				tooltip: { 
					trigger: tooltipTrigger,
					showColorCode: showColorCode,
					textStyle: {
						color: tooltipTextColor
					}
				},
				hAxis: {
					title: hAxisTitle,
					textPosition: hAxisTextPosition,
					direction: hAxisDirection,
					textStyle: {
						color: hAxisTextColor
					},
					slantedText: hAxisSlantedText,
					slantedTextAngle: hAxisSlantedTextAngle
				},
				vAxis: {
					title: vAxisTitle,
					textPosition: vAxisTextPosition,
					direction: vAxisDirection,
					textStyle: {
						color: vAxisTextColor
					}
				},
				focusTarget: focusTarget,
				isStacked: isStacked,
				dataOpacity: opacity,
				animation: {
					startup: enableAnimation,
					duration: animationDuration,
        			easing: 'linear',
				}
			};

			_this.chartObj = new google.visualization.BarChart(document.getElementById(_this.htmlClassPrefix + chartType + _this.uniqueId));

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}

	// Load chart by column chart
	AysChartPlugin.prototype.columnChartView = function( chartType ){
		var _this = this;
		var getChartSource = _this.dbData.source;

		// Collect data in new array for chart rendering (Column chart)
		var dataTypes = _this.multiColumnChartConvertData( getChartSource );

		var settings = _this.dbData.options;
		var chartFontSize = settings['font_size'];
		var tooltipTrigger = settings['tooltip_trigger'];
		var isStacked = (settings['is_stacked'] == 'on') ? true : false;
		var focusTarget = settings['focus_target'];
		var showColorCode = (settings['show_color_code'] == 'on') ? true : false;
		var tooltipTextColor = settings['tooltip_text_color'];
		var legendPosition = settings['legend_position'];
		var legendAlignment = settings['legend_alignment'];
		var legendColor = settings['legend_color'];
		var opacity = settings['opacity'];
		var hAxisTitle = settings['haxis_title'];
		var vAxisTitle = settings['vaxis_title'];
		var hAxisTextPosition = settings['haxis_text_position'];
		var vAxisTextPosition = settings['vaxis_text_position'];
		var vAxisDirection = (settings['vaxis_direction'] == '-1') ? -1 : 1;
		var hAxisDirection = (settings['haxis_direction'] == '-1') ? -1 : 1;
		var hAxisTextColor = settings['haxis_text_color'];
		var vAxisTextColor = settings['vaxis_text_color'];
		var hAxisSlantedText = settings['haxis_slanted'];
		var hAxisSlantedTextAngle = settings['haxis_slanted_text_angle'];

		var enableAnimation = (settings['enable_animation'] == 'on') ? true : false;
		var animationDuration = settings['animation_duration'];

		/* == Google part == */
		google.charts.load('current', {'packages':['corechart']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartData = google.visualization.arrayToDataTable(dataTypes);

			_this.chartOptions = {
				backgroundColor: 'transparent',
				fontSize: chartFontSize,
				legend: {
					position: legendPosition,
					alignment: legendAlignment,
					textStyle: {
						color: legendColor
					}
				},
				tooltip: { 
					trigger: tooltipTrigger,
					showColorCode: showColorCode,
					textStyle: {
						color: tooltipTextColor
					}
				},
				hAxis: {
					title: hAxisTitle,
					textPosition: hAxisTextPosition,
					direction: hAxisDirection,
					textStyle: {
						color: hAxisTextColor
					},
					slantedText: hAxisSlantedText,
					slantedTextAngle: hAxisSlantedTextAngle
				},
				vAxis: {
					title: vAxisTitle,
					textPosition: vAxisTextPosition,
					direction: vAxisDirection,
					textStyle: {
						color: vAxisTextColor
					}
				},
				focusTarget: focusTarget,
				isStacked: isStacked,
				dataOpacity: opacity,
				animation: {
					startup: enableAnimation,
					duration: animationDuration,
        			easing: 'linear',
				}
			};

			_this.chartObj = new google.visualization.ColumnChart(document.getElementById(_this.htmlClassPrefix + chartType + _this.uniqueId));

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}

	// Load chart by line chart
	AysChartPlugin.prototype.lineChartView = function( chartType ){
		var _this = this;
		var getChartSource = _this.dbData.source;
		var dataTypes = _this.multiColumnChartConvertData(getChartSource);

		var settings = _this.dbData.options;
		var chartFontSize = settings['font_size'];
		var tooltipTrigger = settings['tooltip_trigger'];
		var focusTarget = settings['focus_target'];
		var showColorCode = (settings['show_color_code'] == 'on') ? true : false;
		var tooltipTextColor = settings['tooltip_text_color'];
		var legendPosition = settings['legend_position'];
		var legendAlignment = settings['legend_alignment'];
		var legendColor = settings['legend_color'];
		var opacity = settings['opacity'];
		var hAxisTitle = settings['haxis_title'];
		var vAxisTitle = settings['vaxis_title'];
		var hAxisTextPosition = settings['haxis_text_position'];
		var vAxisTextPosition = settings['vaxis_text_position'];
		var vAxisDirection = (settings['vaxis_direction'] == '-1') ? -1 : 1;
		var hAxisDirection = (settings['haxis_direction'] == '-1') ? -1 : 1;
		var hAxisTextColor = settings['haxis_text_color'];
		var vAxisTextColor = settings['vaxis_text_color'];
		var hAxisSlantedText = settings['haxis_slanted'];
		var hAxisSlantedTextAngle = settings['haxis_slanted_text_angle'];
		var lineWidth = settings['line_width'];

		var enableAnimation = (settings['enable_animation'] == 'on') ? true : false;
		var animationDuration = settings['animation_duration'];

		/* == Google part == */
		google.charts.load('current', {'packages':['corechart']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartData = google.visualization.arrayToDataTable(dataTypes);

			_this.chartOptions = {
				backgroundColor: 'transparent',
				fontSize: chartFontSize,
				legend: {
					position: legendPosition,
					alignment: legendAlignment,
					textStyle: {
						color: legendColor
					}
				},
				tooltip: { 
					trigger: tooltipTrigger,
					showColorCode: showColorCode,
					textStyle: {
						color: tooltipTextColor
					}
				},
				hAxis: {
					title: hAxisTitle,
					textPosition: hAxisTextPosition,
					direction: hAxisDirection,
					textStyle: {
						color: hAxisTextColor
					},
					slantedText: hAxisSlantedText,
					slantedTextAngle: hAxisSlantedTextAngle
				},
				vAxis: {
					title: vAxisTitle,
					textPosition: vAxisTextPosition,
					direction: vAxisDirection,
					textStyle: {
						color: vAxisTextColor
					}
				},
				focusTarget: focusTarget,
				dataOpacity: opacity,
				lineWidth: lineWidth,
				animation: {
					startup: enableAnimation,
					duration: animationDuration,
        			easing: 'linear',
				}
			};

			_this.chartObj = new google.visualization.LineChart(document.getElementById(_this.htmlClassPrefix + chartType + _this.uniqueId));

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}

	// Detect window resize moment to draw charts responsively
	AysChartPlugin.prototype.resizeChart = function(){
		var _this = this;

		//create trigger to resizeEnd event
		$(window).resize(function() {
			if(this.resizeTO) clearTimeout(this.resizeTO);
			this.resizeTO = setTimeout(function() {
				$(this).trigger('resizeEnd');
			}, 100);
		});

		//redraw graph when window resize is completed
		$(window).on('resizeEnd', function() {
			_this.chartObj.draw( _this.chartData, _this.chartOptions );
		});

	}

	// Load chart by pie chart
	AysChartPlugin.prototype.chartConvertData = function( data ){
		var _this = this;
		var dataTypes = [];

		// Collect data in new array for chart rendering
		for ( var key in data ) {
			if ( data.hasOwnProperty( key ) ) {
				if (key == 0) {
					if (data[key][0] != '' && data[key][1] != '') {
						dataTypes.push([
							_this.htmlDecode(data[key][0]), _this.htmlDecode(data[key][1])
						]);
					}
				} else {
					if (data[key][0] != '' && data[key][1] != '') {
						dataTypes.push([
							_this.htmlDecode(data[key][0]), +(data[key][1])
						]);
					}
				}
			}
		}

		return dataTypes;
	}

	// Converting chart data for multicolumn chart
	AysChartPlugin.prototype.multiColumnChartConvertData = function( data ){
		var _this = this;
		var dataTypes = [];
		var titleRow = [];

		for (var key in data) {
			var dataRow = [];
			if (data.hasOwnProperty(key)) {
				if (key == 0) {
					for (var index in data[key]) {
						if (data[key][index] != '') {
							titleRow.push(_this.htmlDecode(data[key][index]));
						}
					}
					dataTypes.push(titleRow);
				} else {
					for (var index in data[key]) {
						if (data[key][index] != '') {
							if  (index == 0) {
								dataRow.push(_this.htmlDecode(data[key][index]));
							} else {
								dataRow.push(+data[key][index]);
							}
						}
					}
					dataTypes.push(dataRow);
				}
			}
		}

		return dataTypes;
	}

	// Update chart data and display immediately
	AysChartPlugin.prototype.updateChartData =  function( newData ){
		var _this = this;
		_this.chartObj.draw( newData, _this.chartOptions );
	}

	AysChartPlugin.prototype.htmlDecode = function (input) {
		var e = document.createElement('div');
		e.innerHTML = input;
		return e.childNodes[0].nodeValue;
	}

	$.fn.AysChartBuilder = function(options) {
		return this.each(function() {
			if (!$.data(this, 'AysChartBuilder')) {
				$.data(this, 'AysChartBuilder', new AysChartPlugin(this, options));
			} else {
				try {
					$(this).data('AysChartBuilder').init();
				} catch (err) {
					console.error('AysChartBuilder has not initiated properly');
				}
			}
		});
	};

})(jQuery);
