<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       http://ays-pro.com/
 * @since      1.0.0
 *
 * @package    Chart_Builder
 * @subpackage Chart_Builder/includes
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Chart_Builder
 * @subpackage Chart_Builder/includes
 * @author     AYS Pro LLC <info@ays-pro.com>
 */
class Chart_Builder_Integrations
{

    /**
     * The ID of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string $plugin_name The ID of this plugin.
     */
    private $plugin_name;

    /**
     * The version of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string $version The current version of this plugin.
     */
    private $version;

    private $settings_obj;

    private $capability;

    private $blockquote_content;

    /**
     * Initialize the class and set its properties.
     *
     * @since    1.0.0
     * @param      string $plugin_name The name of this plugin.
     * @param      string $version The version of this plugin.
     */
    public function __construct($plugin_name, $version){

        $this->plugin_name = $plugin_name;
        $this->version = $version;
        $this->settings_obj = new Chart_Builder_Settings_DB_Actions($this->plugin_name);

        $settings_url = sprintf(
            __( "For enabling this option, please go to %s page and fill all options.", $this->plugin_name ),
            "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=".$this->plugin_name."-settings&ays_tab=tab2' target='_blank'>". __( "this", $this->plugin_name ) ."</a>"
        );
        $blockquote_content = '<blockquote class="error_message">'. $settings_url .'</blockquote>';
        $this->blockquote_content = $blockquote_content;
    }

    // ===== INTEGRATIONS HOOKS =====

    public function ays_chart_page_integrations_content( $args ){

        if( ! $this->settings_obj->get_permission_for_editing_plugin() ){
            $settings_url = __( "This functionality is disabled.", $this->plugin_name );
            $blockquote_content = '<blockquote class="error_message">'. $settings_url .'</blockquote>';
            $this->blockquote_content = $blockquote_content;
        }

        $integrations_contents = apply_filters( 'ays_cb_chart_page_integrations_contents', array(), $args );
        
        $integrations = array();

        foreach ($integrations_contents as $key => $integrations_content) {
            $content = '<fieldset>';
            if(isset($integrations_content['title'])){
                $content .= '<legend>';
                if(isset($integrations_content['icon'])){
                    $content .= '<img class="ays_integration_logo" src="'. $integrations_content['icon'] .'" alt="">';
                }
                $content .= '<h5>'. $integrations_content['title'] .'</h5></legend>';
            }
            $content .= $integrations_content['content'];

            $content .= '</fieldset>';

            $integrations[] = $content;
        }

        echo implode('<hr/>', $integrations);

    }

    // Integrations settings page action hook
    public function ays_settings_page_integrations_content( $args ){

        $integrations_contents = apply_filters( 'ays_cb_settings_page_integrations_contents', array(), $args );
        
        $integrations = array();

        foreach ($integrations_contents as $key => $integrations_content) {
            $content = '<fieldset class="only_pro">';
            if(isset($integrations_content['title'])){
                $content .= '<legend>';
                if(isset($integrations_content['icon'])){
                    $content .= '<img class="ays_integration_logo" src="'. $integrations_content['icon'] .'" alt="">';
                }
                $content .= '<h5>'. $integrations_content['title'] .'</h5></legend>';
            }
            if(isset($integrations_content['content'])){
                $content .= $integrations_content['content'];
            }

            $content .= '</fieldset>';

            $integrations[] = $content;
        }

        echo implode('<hr/>', $integrations);
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    //====================================================================================//
    ////////////////////////////////////////////////////////////////////////////////////////

    // ===== Google sheet starts =====

        public function source_contents_import_from_google_sheet_settings( $sources, $args ){

            $html_class_prefix = $args['html_class_prefix'];
			$html_name_prefix = $args['html_name_prefix'];

            ob_start();
            ?>
            <div class="ays-accordion-data-main-wrap only_pro">
                <div class="pro_features">
                    <div>
                        <p>
                            <?php echo __("This feature is available only in ", $this->plugin_name); ?>
                            <a href="https://ays-pro.com/wordpress/chart-builder/" target="_blank" title="PRO feature"><?php echo __("PRO version!!!", $this->plugin_name); ?></a>
                        </p>
                    </div>
                </div>
                <div class="<?= $html_class_prefix ?>source-data-main-wrap">
                    <div class="<?= $html_class_prefix ?>chart-source-data-main">
                        <div id="ays-chart-google-sheet-form">
                            <div class="<?= $html_class_prefix ?>google-sheet-select-wrap">
                                <select name="<?= $html_name_prefix ?>google_sheet_id" id="" class="<?= $html_class_prefix ?>google-sheet-select" data-chart-id="1">
                                    <option value=""><?= __( 'Select spreadsheet', $this->plugin_name ) ?></option>
                                </select>
                            </div>
                            <div class="ays-chart-buttons-group">
                                <input type="button" class="button button-primary" id="ays-chart-gsheet-fetch" value="<?php _e( "Show Results", $this->plugin_name ); ?>">
                                <input type="button" class="button button-primary" id="ays-chart-gsheet-show-on-chart" value="<?php _e( "Show on chart", $this->plugin_name ); ?>">
                                <input type="button" class="button button-primary" id="ays-chart-gsheet-save" value="<?php _e( "Save query", $this->plugin_name ); ?>">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php
            $content = ob_get_clean();

            $title = __( 'Connect to Google Sheets', $this->plugin_name ) . ' <a class="ays_help" data-bs-toggle="tooltip" title="' . __("Activate Google Integration to import the information from the Google Sheets.",$this->plugin_name) . '">
                            <i class="ays_fa ays_fa_info_circle"></i>
                        </a>';

            $sources['google_sheet'] = array(
                'content' => $content,
                'title' => $title
            );

            return $sources;
        }

        // Google sheet integration / settings page
        // Google sheet integration / settings page content    
        public function ays_settings_page_google_sheet_content($integrations, $args){
            $icon  = CHART_BUILDER_ADMIN_URL . '/images/integrations/google_logo.png';
            $title = __( 'Google', $this->plugin_name );

            $content = '<div class="pro_features">
                            <div>
                                <p>
                                    ' . __("This feature is available only in ", $this->plugin_name) . '
                                    <a href="https://ays-pro.com/wordpress/chart-builder/" target="_blank" title="PRO feature">' . __("PRO version!!!", $this->plugin_name) . '</a>
                                </p>
                            </div>
                        </div>
                        <div class="form-group row">
                            <div class="col-sm-12">
                                <div class="form-group row" aria-describedby="aaa">
                                    <div class="col-sm-3">
                                        <button id="googleInstructionsPopOver" type="button" class="btn btn-info" data-original-title="Google Integration Setup Instructions" >'. __("Instructions", $this->plugin_name). '</button>
                                        <div class="d-none" id="googleInstructions">
                                            <p>1. '. __("Turn on Your Google Sheet API", $this->plugin_name) .'
                                                <a href="https://console.developers.google.com" target="_blank">https://console.developers.google.com</a>
                                            </p>
                                            <p>2. <a href="https://console.developers.google.com/apis/credentials" target="_blank">'. __("Create ", $this->plugin_name) .'</a>'. __("new Google Oauth client ID credentials (if you do not still have)", $this->plugin_name).'</p>
                                            <p>3. '. __("Choose the application type as <b>Web application</b>", $this->plugin_name) .'</p>
                                            <p>4. '. __("Add the following link in the <b>Authorized redirect URIs</b> field", $this->plugin_name) .'</p>
                                            <p>
                                                <code>Redirect url</code>
                                            </p>
                                            <p>5. '. __("Click on the <b>Create</b> button", $this->plugin_name) .'</p>
                                            <p>6. '. __("Copy the <b>Your Client ID</b> and <b>Your Client Secret</b> from the opened popup and paste them in the corresponding fields.", $this->plugin_name) .'</p>
                                            <p>7. '. __("Click on the <b>Connect</b> button to complete authorization", $this->plugin_name) .'</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <div class="col-sm-3">
                                        <label for="ays_google_client">
                                            '. __("Google Client ID", $this->plugin_name) .'
                                        </label>
                                    </div>
                                    <div class="col-sm-9">
                                        <input type="text" class="ays-text-input" id="ays_google_client" name="ays_google_client" value="">
                                    </div>
                                </div>
                                <hr/>
                                <div class="form-group row">
                                    <div class="col-sm-3">
                                        <label for="ays_google_secret">
                                            '. __("Google Client Secret", $this->plugin_name) .'
                                        </label>
                                    </div>
                                    <div class="col-sm-9">
                                        <input type="text" class="ays-text-input" id="ays_google_secret" name="ays_google_secret" value="">
                                        <input type="hidden" id="ays_google_redirect" name="ays_google_redirect" value="">
                                    </div>
                                </div>
                                <hr/>
                                <div class="form-group row">
                                    <div class="col-sm-3"></div>
                                    <div class="col-sm-9">
                                        <button type="submit" name="ays_googleOAuth2" id="ays_googleOAuth2" class="btn btn-outline-info">
                                            '. __("Connect", $this->plugin_name) .'
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>';
                        
            $integrations['google'] = array(
                'content' => $content,
                'icon' => $icon,
                'title' => $title
            );
            return $integrations;        
        }
        
    // =====  Google sheet end   =====

}
