(function(wp){
    var el = wp.element.createElement,
        registerBlockType = wp.blocks.registerBlockType,
        withSelect = wp.data.withSelect,
        BlockControls = wp.editor.BlockControls,
        AlignmentToolbar = wp.editor.AlignmentToolbar,
        InspectorControls = wp.blocks.InspectorControls,
        ServerSideRender = wp.components.ServerSideRender,
        __ = wp.i18n.__,
        Text = wp.components.TextControl,
        aysSelect = wp.components.SelectControl,
        createBlock = wp.blocks.createBlock,
        select = wp.data.select,
        dispatch = wp.data.dispatch,
        Text = wp.components.TextControl,
        Dashicon = wp.components.Dashicon;
        var iconEl = el(
            'svg', 
            { 
                width: 256,
                height: 256,
                viewBox: '0 0 2560 2560'
            },
            el(
                'g',
                { 
                    fill: 'rgb(250,251,253)'
                },
                el(
                    'path',
                    { 
                        d: "M1220 2169 c-202 -25 -378 -112 -520 -259 -91 -94 -159 -204 -201 -330 -30 -89 -33 -106 -37 -263 -4 -147 -2 -179 17 -262 53 -229 195 -421 403 -547 131 -80 241 -109 441 -115 139 -5 169 -3 254 17 176 41 390 174 469 292 66 98 52 262 -28 334 -49 45 -89 58 -178 59 -71 0 -92 -4 -127 -24 -22 -13 -50 -36 -61 -51 -30 -39 -119 -95 -193 -120 -172 -59 -377 36 -473 219 -46 88 -60 140 -60 232 -1 67 3 83 37 151 80 163 246 266 411 256 129 -8 262 -88 335 -200 59 -91 55 -88 124 -88 82 0 130 15 173 52 57 50 74 95 74 189 0 105 -20 148 -103 225 -116 107 -260 184 -408 218 -85 19 -256 27 -349 15z",
                    }
                ),
            ),
            el(
                'g',
                { 
                    fill: 'rgb(226,233,241)'
                },
                el(
                    'path',
                    { 
                        d: "M1218 2173 c-30 -3 -38 -8 -38 -24 0 -19 4 -20 43 -13 23 4 84 7 135 7 83 0 92 2 92 18 0 17 -8 19 -97 17 -54 -1 -115 -3 -135 -5z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1460 2156 c0 -9 25 -19 70 -30 133 -30 263 -93 383 -186 l27 -22 0 31 c0 26 -4 31 -25 31 -18 0 -25 5 -25 20 0 11 -7 20 -15 20 -8 0 -15 5 -15 10 0 6 -5 10 -11 10 -6 0 -17 7 -25 15 -9 8 -29 15 -45 15 -18 0 -29 5 -29 14 0 15 -21 26 -50 26 -10 0 -20 4 -22 10 -4 12 -149 50 -190 50 -17 0 -28 -5 -28 -14z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1038 2133 c-10 -2 -18 -9 -18 -14 0 -5 -9 -9 -19 -9 -30 0 -51 -11 -51 -26 0 -9 -11 -14 -30 -14 -20 0 -30 -5 -30 -15 0 -9 -9 -15 -25 -15 -14 0 -25 -4 -25 -10 0 -5 -7 -10 -15 -10 -8 0 -15 -7 -15 -15 0 -8 -9 -15 -20 -15 -23 0 -33 -18 -28 -48 3 -18 10 -15 68 29 69 52 177 109 248 130 51 15 57 40 10 38 -18 -1 -41 -3 -50 -6z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M647 1863 c-4 -3 -7 -15 -7 -25 0 -10 -7 -18 -15 -18 -8 0 -15 -7 -15 -15 0 -8 -4 -15 -10 -15 -5 0 -10 -5 -10 -11 0 -6 -7 -17 -15 -25 -15 -16 -21 -84 -7 -84 4 0 26 31 50 68 23 37 54 82 68 100 l27 32 -30 0 c-16 0 -33 -3 -36 -7z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M2012 1835 c29 -44 38 -44 38 0 0 32 -2 35 -30 35 l-30 0 22 -35z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1285 1790 c-183 -28 -338 -164 -384 -338 -16 -56 -16 -172 0 -219 29 -93 35 -107 48 -111 11 -4 13 5 7 44 -17 119 -17 143 -2 213 35 166 126 271 287 332 148 57 329 -10 439 -162 48 -65 52 -69 90 -69 44 0 48 5 25 29 -8 9 -34 44 -56 79 -95 145 -282 228 -454 202z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M520 1636 c0 -13 -4 -26 -10 -28 -12 -4 -50 -150 -50 -195 0 -48 27 -44 35 5 3 20 21 83 39 140 l33 102 -23 0 c-19 0 -24 -5 -24 -24z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M450 1280 c0 -83 1 -90 20 -90 19 0 20 7 20 90 0 83 -1 90 -20 90 -19 0 -20 -7 -20 -90z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M460 1154 c0 -41 41 -204 51 -204 5 0 9 -9 9 -20 0 -11 10 -40 22 -65 17 -34 28 -45 45 -45 13 0 23 2 23 4 0 3 -18 41 -39 86 -22 45 -50 124 -62 176 -14 63 -26 94 -35 94 -8 0 -14 -11 -14 -26z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1680 1025 l0 -34 26 24 c15 14 31 25 35 25 5 0 9 5 9 10 0 6 -16 10 -35 10 -33 0 -35 -2 -35 -35z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M620 768 c0 -27 4 -38 15 -38 8 0 15 -8 15 -18 0 -26 20 -42 53 -42 l28 0 -20 28 c-11 15 -36 45 -55 67 l-35 40 -1 -37z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M742 629 c2 -29 7 -34 31 -37 19 -2 27 -9 27 -23 0 -10 7 -19 15 -19 8 0 15 -4 15 -10 0 -5 7 -10 15 -10 8 0 15 -4 15 -10 0 -5 16 -10 35 -10 28 0 35 -4 35 -20 0 -16 7 -20 35 -20 23 0 35 -5 35 -13 0 -15 46 -31 145 -53 82 -18 125 -18 125 1 0 8 -1 15 -3 15 -22 0 -137 26 -187 42 -106 34 -201 88 -308 175 l-34 27 4 -35z",
                    }
                )
            ),
            el(
                'g',
                { 
                    fill: 'rgb(187,204,222)'
                },
                el(
                    'path',
                    { 
                        d: "M872 2503 c3 -36 5 -38 41 -41 l38 -3 -3 38 c-3 36 -5 38 -41 41 l-38 3 3 -38z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1156 2164 c-88 -17 -166 -43 -166 -55 0 -5 -9 -9 -19 -9 -30 0 -51 -11 -51 -26 0 -8 -10 -14 -24 -14 -14 0 -31 -7 -40 -15 -8 -8 -19 -15 -25 -15 -6 0 -11 -7 -11 -15 0 -8 -9 -15 -20 -15 -15 0 -20 -7 -20 -25 0 -21 -5 -25 -28 -25 -36 0 -72 -37 -72 -73 0 -22 -5 -27 -25 -27 -18 0 -25 -5 -25 -20 0 -11 -7 -20 -15 -20 -8 0 -15 -7 -15 -15 0 -8 -4 -15 -10 -15 -5 0 -10 -11 -10 -25 0 -14 -6 -25 -13 -25 -16 0 -37 -41 -37 -70 0 -11 -4 -20 -9 -20 -20 0 -71 -208 -71 -291 0 -53 27 -54 34 -1 37 251 113 411 269 559 143 135 284 200 520 238 23 4 37 11 37 20 0 19 -58 19 -154 -1z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1390 2166 c0 -13 28 -26 58 -26 6 0 12 9 12 20 0 16 -7 20 -35 20 -23 0 -35 -5 -35 -14z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1642 2108 c3 -7 19 -18 36 -25 31 -13 32 -12 32 12 0 22 -4 25 -36 25 -23 0 -34 -4 -32 -12z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1277 1760 c-156 -28 -298 -153 -341 -299 -21 -73 -21 -91 4 -91 11 0 20 5 20 11 0 28 56 119 103 167 132 134 298 168 453 92 66 -32 174 -124 174 -147 0 -16 58 -17 80 -3 13 9 13 12 -2 20 -9 6 -37 39 -62 74 -95 134 -269 205 -429 176z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1754 1358 c3 -29 6 -70 6 -90 0 -37 1 -38 35 -38 34 0 35 1 35 38 0 20 -3 61 -6 90 -7 52 -7 52 -42 52 l-35 0 7 -52z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M450 1208 c0 -58 37 -232 50 -236 5 -2 10 -15 10 -28 0 -13 5 -24 10 -24 6 0 10 -9 10 -19 0 -30 11 -51 26 -51 8 0 14 -10 14 -25 0 -14 5 -25 10 -25 6 0 10 -7 10 -15 0 -8 5 -15 10 -15 6 0 10 -7 10 -15 0 -8 4 -15 9 -15 5 0 11 -9 14 -20 4 -15 14 -20 36 -20 l31 0 -59 86 c-89 127 -127 231 -156 427 -8 54 -35 50 -35 -5z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1736 1168 c-3 -13 -6 -35 -6 -50 0 -25 4 -28 34 -28 36 0 46 15 46 73 0 24 -4 27 -34 27 -26 0 -35 -5 -40 -22z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M762 609 c2 -26 8 -35 26 -37 12 -2 22 -10 22 -18 0 -8 7 -14 15 -14 8 0 15 -4 15 -10 0 -5 5 -10 11 -10 6 0 17 -7 25 -15 9 -8 27 -18 42 -22 15 -3 33 -12 40 -19 19 -19 166 -64 233 -71 50 -5 59 -3 59 10 0 11 -17 19 -57 27 -150 30 -267 84 -406 191 l-28 22 3 -34z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1260 400 c0 -19 7 -20 90 -20 83 0 90 1 90 20 0 19 -7 20 -90 20 -83 0 -90 -1 -90 -20z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1170 215 c0 -21 -5 -25 -30 -25 -28 0 -30 -3 -30 -35 0 -33 2 -35 35 -35 31 0 35 3 35 25 0 21 5 25 30 25 28 0 30 3 30 35 0 33 -2 35 -35 35 -31 0 -35 -3 -35 -25z",
                    }
                )
            ),
            el(
                'g',
                { 
                    fill: 'rgb(255,111,213)'
                },
                el(
                    'path',
                    { 
                        d: "M1295 1713 c-180 -26 -332 -162 -376 -336 -6 -27 -10 -82 -7 -127 9 -153 108 -293 255 -363 58 -27 82 -32 163 -35 144 -6 249 35 351 137 25 25 59 53 75 62 48 25 67 106 62 255 -5 145 -21 191 -76 219 -20 11 -48 33 -62 49 -36 42 -136 104 -195 121 -58 16 -147 25 -190 18z",
                    }
                )
            ),
            el(
                'g',
                { 
                    fill: 'rgb(145,244,176)'
                },
                el(
                    'path',
                    { 
                        d: "M2078 1665 c-22 -10 -41 -28 -48 -46 -18 -42 -82 -96 -132 -109 -23 -7 -63 -9 -87 -6 l-44 6 7 -43 c28 -173 25 -262 -9 -345 l-15 -35 48 7 c75 10 111 -2 163 -54 65 -65 92 -121 92 -191 -1 -88 -38 -143 -158 -239 -131 -104 -275 -164 -454 -190 l-77 -12 -97 -93 c-53 -51 -151 -135 -219 -186 -69 -52 -124 -100 -126 -111 -3 -19 7 -19 480 -15 523 4 558 7 693 64 193 81 358 259 420 456 38 121 45 219 45 693 l0 441 -57 7 c-32 3 -132 9 -223 11 -137 5 -171 3 -202 -10z",
                    }
                )
            ),
            el(
                'g',
                { 
                    fill: 'rgb(137,237,185)'
                },
                el(
                    'path',
                    { 
                        d: "M2269 1893 l-196 -3 -12 -70 c-6 -38 -11 -90 -11 -115 0 -52 -18 -95 -64 -145 -25 -28 -23 -27 14 7 72 67 121 80 280 77 74 -1 164 -7 199 -14 52 -9 66 -9 72 2 10 16 11 121 3 207 l-7 61 -41 -2 c-23 -2 -129 -4 -237 -5z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1740 1508 c0 -7 11 -40 25 -73 13 -33 25 -75 25 -92 0 -18 4 -33 9 -33 5 0 12 -8 15 -17 6 -20 0 162 -6 189 -5 22 -7 24 -40 32 -20 4 -28 2 -28 -6z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1772 1138 c3 -7 -2 -20 -11 -28 -13 -13 -7 -16 55 -21 77 -6 98 -15 156 -67 41 -37 66 -77 79 -127 6 -19 6 -8 3 30 -11 111 -70 182 -170 204 -31 7 -58 10 -61 8 -3 -3 -16 -1 -30 4 -19 7 -24 6 -21 -3z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1340 364 c0 -39 9 -38 40 6 l21 30 -30 0 c-29 0 -31 -3 -31 -36z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1214 266 c-3 -8 -4 -24 -2 -36 3 -20 5 -20 43 14 l40 35 -38 1 c-24 0 -40 -5 -43 -14z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1140 185 c0 -29 7 -31 38 -9 30 21 28 34 -8 34 -25 0 -30 -4 -30 -25z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M970 49 l0 -30 30 21 c44 31 45 40 6 40 -33 0 -36 -2 -36 -31z",
                    }
                )
            ),
            el(
                'g',
                { 
                    fill: 'rgb(123,229,195)'
                },
                el(
                    'path',
                    { 
                        d: "M2160 2189 c-85 -4 -175 -12 -200 -18 -25 -6 -63 -11 -86 -11 -82 0 -88 -57 -15 -134 67 -70 161 -192 177 -232 8 -19 14 -55 15 -81 l0 -48 18 45 c10 25 22 69 26 98 l7 52 191 0 c106 1 207 1 226 1 l33 0 -6 52 c-9 70 -42 172 -74 232 l-27 48 -65 2 c-36 1 -135 -1 -220 -6z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1742 1498 c2 -13 11 -24 20 -26 13 -2 16 1 12 12 -4 11 0 16 12 16 23 0 16 6 -19 14 -25 6 -28 4 -25 -16z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1745 1075 c-34 -38 -32 -49 8 -29 46 24 132 22 183 -4 39 -20 87 -66 97 -94 10 -28 16 0 7 33 -12 40 -51 89 -73 89 -8 0 -17 6 -19 12 -3 9 -34 14 -91 16 -83 4 -87 3 -112 -23z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1327 383 c-4 -3 -7 -22 -7 -41 0 -30 2 -33 15 -22 9 7 25 26 36 42 l20 28 -29 0 c-16 0 -32 -3 -35 -7z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1230 259 l0 -30 30 21 c44 31 45 40 6 40 -33 0 -36 -2 -36 -31z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1090 155 c0 -8 -9 -15 -20 -15 -11 0 -20 -7 -20 -15 0 -8 -9 -15 -20 -15 -15 0 -20 -7 -20 -25 0 -22 -4 -25 -35 -25 -19 0 -35 -4 -35 -10 0 -5 -7 -10 -15 -10 -8 0 -15 -9 -15 -20 0 -12 7 -20 16 -20 16 0 164 103 211 146 l26 24 -37 0 c-25 0 -36 -4 -36 -15z",
                    }
                )
            ),
            el(
                'g',
                { 
                    fill: 'rgb(117,222,201)'
                },
                el(
                    'path',
                    { 
                        d: "M2140 2279 c-124 -5 -253 -13 -286 -19 -34 -5 -84 -10 -113 -10 -28 0 -51 -4 -51 -10 0 -5 -9 -10 -20 -10 -16 0 -20 -7 -20 -34 0 -28 6 -38 39 -59 73 -48 316 -279 339 -322 9 -16 16 -33 17 -37 0 -3 4 -10 9 -15 16 -15 -4 61 -28 110 -31 61 -74 119 -136 183 -59 61 -55 68 40 78 36 3 81 9 100 11 108 16 351 22 380 11 9 -4 23 -1 32 6 16 12 14 18 -20 67 -21 30 -42 55 -48 56 -5 1 -110 -2 -234 -6z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1728 1510 c18 -31 42 -40 42 -16 0 12 -40 46 -54 46 -3 0 3 -13 12 -30z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1780 1080 c0 -15 5 -19 23 -16 12 3 28 5 35 5 6 1 12 8 12 16 0 10 -11 15 -35 15 -28 0 -35 -4 -35 -20z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1900 1072 c0 -7 17 -18 63 -40 4 -2 7 8 7 22 0 23 -4 26 -35 26 -19 0 -35 -4 -35 -8z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1398 413 c-10 -2 -18 -12 -18 -20 0 -14 3 -14 20 2 17 15 26 28 18 24 -2 -1 -11 -3 -20 -6z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1310 335 c0 -33 -2 -35 -35 -35 -32 0 -35 -2 -35 -31 l0 -30 28 19 c26 19 64 58 91 95 12 15 10 17 -18 17 -29 0 -31 -2 -31 -35z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1150 189 c0 -28 2 -30 18 -18 9 7 25 21 35 31 17 17 16 18 -18 18 -33 0 -35 -2 -35 -31z",
                    }
                )
            ),
            el(
                'g',
                { 
                    fill: 'rgb(110,219,205)'
                },
                el(
                    'path',
                    { 
                        d: "M1991 2430 c-134 -14 -161 -20 -161 -36 0 -11 -15 -14 -61 -14 -58 0 -183 -22 -224 -40 -11 -4 -35 -14 -52 -22 -18 -7 -33 -16 -33 -20 0 -5 -7 -8 -15 -8 -10 0 -15 -10 -15 -34 0 -32 4 -36 58 -61 131 -61 206 -100 231 -120 14 -11 52 -36 85 -55 32 -19 98 -73 147 -118 49 -47 89 -77 89 -69 0 33 -189 236 -295 315 -27 20 -31 30 -26 60 0 5 25 9 54 10 28 2 75 6 102 11 28 5 61 9 75 8 69 0 427 15 439 19 17 5 -53 81 -132 145 -47 38 -51 39 -120 38 -40 -1 -105 -5 -146 -9z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1320 2287 c0 -38 12 -47 61 -47 29 0 30 2 27 38 -3 36 -4 37 -45 40 -43 3 -43 3 -43 -31z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1250 279 l0 -30 30 21 c44 31 45 40 6 40 -33 0 -36 -2 -36 -31z",
                    }
                )
            ),
            el(
                'g',
                { 
                    fill: 'rgb(103,211,217)'
                },
                el(
                    'path',
                    { 
                        d: "M832 2538 c2 -14 66 -84 159 -175 122 -120 162 -153 182 -153 21 0 27 -5 27 -21 0 -21 3 -22 61 -15 34 3 77 6 95 6 32 0 34 2 34 36 l0 37 -90 -6 c-79 -5 -90 -4 -90 11 0 9 -14 31 -32 49 -28 29 -30 33 -12 33 11 0 43 11 72 25 28 14 77 28 107 31 31 4 63 13 70 20 7 8 25 14 40 14 14 0 34 4 44 10 16 8 193 50 213 50 4 0 8 -7 8 -15 0 -22 67 -20 258 11 39 6 45 39 9 48 -77 19 -257 26 -680 26 l-478 0 3 -22z",
                        fill: 'rgb(103,211,217)'
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1400 2167 c0 -11 12 -18 38 -22 91 -14 210 -47 269 -75 36 -16 67 -30 69 -30 2 0 4 9 4 21 0 12 -8 23 -20 26 -11 3 -20 9 -20 14 0 5 -11 9 -25 9 -14 0 -25 4 -25 9 0 13 -147 51 -224 58 -56 5 -66 4 -66 -10z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1883 1965 c29 -25 47 -32 47 -17 0 15 -36 42 -56 42 -16 -1 -15 -4 9 -25z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1722 1520 c7 -11 19 -20 27 -20 11 0 9 6 -7 20 -12 11 -24 20 -27 20 -3 0 0 -9 7 -20z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1160 205 c0 -21 -5 -25 -30 -25 -27 0 -30 -3 -30 -31 0 -36 -5 -39 105 55 l30 26 -37 0 c-34 0 -38 -3 -38 -25z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M980 59 l0 -30 30 21 c44 31 45 40 6 40 -33 0 -36 -2 -36 -31z",
                    }
                )
            ),
            el(
                'g',
                { 
                    fill: 'rgb(104,214,211)'
                },
                el(
                    'path',
                    { 
                        d: "M1735 2530 c-16 -5 -73 -16 -125 -26 -52 -9 -110 -23 -127 -30 -20 -8 -35 -9 -38 -3 -4 5 -12 6 -18 2 -12 -8 -17 -9 -38 -12 -5 0 -8 -5 -4 -10 7 -12 -18 -20 -70 -22 -22 -2 -67 -15 -99 -31 -33 -15 -65 -28 -72 -28 -7 0 -25 -5 -39 -12 l-26 -12 53 -55 c46 -49 44 -47 -15 9 -65 62 -86 87 -49 59 15 -13 16 -12 3 4 -8 9 -16 15 -19 12 -3 -3 -11 0 -19 6 -10 9 -13 7 -13 -11 0 -14 30 -53 82 -109 l81 -86 136 -1 c158 -1 211 -13 348 -79 76 -37 246 -142 263 -164 14 -17 40 -32 40 -23 0 15 -94 103 -180 166 -70 52 -119 80 -275 152 -38 18 -54 30 -42 32 9 2 17 7 17 12 0 7 21 15 43 18 4 0 18 7 30 14 31 20 128 40 211 43 78 3 115 13 96 25 -19 11 71 23 285 39 l90 6 -67 38 c-100 57 -173 80 -212 68 -17 -6 -58 -12 -91 -15 -33 -2 -68 -7 -77 -11 -11 -4 -18 -3 -18 4 0 6 8 11 18 11 15 1 15 2 -2 15 -11 8 -22 15 -25 14 -3 -1 -19 -5 -36 -9z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1282 337 c-12 -13 -22 -36 -22 -51 l0 -27 30 21 c16 11 39 34 50 50 l21 30 -29 0 c-17 0 -37 -9 -50 -23z",
                    }
                )
            ),
            el(
                'g',
                { 
                    fill: 'rgb(131,139,247)'
                },
                el(
                    'path',
                    { 
                        d: "M755 2530 c-16 -16 -34 -30 -39 -30 -15 0 -46 -57 -46 -85 0 -32 -10 -55 -24 -55 -6 0 -32 -24 -58 -54 -26 -29 -68 -64 -95 -78 -26 -14 -52 -35 -58 -47 -5 -11 -17 -21 -25 -21 -51 -1 -165 -60 -175 -90 -4 -11 -10 -20 -14 -20 -4 0 -18 -10 -31 -22 -16 -15 -25 -18 -28 -10 -6 18 -72 16 -72 -3 0 -8 -9 -15 -19 -15 -65 0 -74 -108 -69 -790 5 -593 7 -614 73 -757 47 -102 149 -243 176 -243 5 0 9 15 9 34 0 24 -7 39 -21 50 l-21 14 21 14 c11 7 21 18 21 24 0 6 16 27 35 47 19 20 35 41 35 46 0 12 26 46 53 70 10 9 25 28 33 43 8 16 23 28 34 28 13 0 20 7 20 20 0 11 7 23 15 26 8 4 15 15 15 26 0 11 8 22 20 25 11 3 20 9 20 14 0 13 33 49 45 49 23 0 65 -26 65 -40 0 -21 91 -110 113 -110 9 0 17 -7 17 -16 0 -9 9 -18 20 -21 11 -3 20 -9 20 -14 0 -5 7 -9 15 -9 8 0 15 -4 15 -10 0 -5 7 -10 15 -10 8 0 15 -4 15 -8 0 -11 86 -52 110 -52 11 0 20 -4 20 -9 0 -14 148 -50 233 -57 65 -6 77 -5 77 8 0 17 -29 28 -76 28 -52 0 -185 38 -263 75 -303 144 -501 454 -501 785 0 95 23 224 55 305 13 33 25 67 27 75 2 8 5 17 8 20 4 3 27 37 53 76 140 213 349 344 620 389 23 4 37 11 37 20 0 8 -4 15 -10 15 -5 0 -10 6 -10 14 0 9 -7 12 -20 9 -15 -4 -61 35 -206 176 -163 159 -189 181 -218 181 -23 0 -41 -9 -61 -30z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1350 378 l0 -32 30 29 c17 16 30 30 30 32 0 2 -13 3 -30 3 -27 0 -30 -3 -30 -32z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1192 258 c-7 -7 -12 -22 -12 -35 0 -19 -5 -23 -30 -23 -23 0 -30 -4 -30 -20 0 -15 -7 -20 -25 -20 -16 0 -25 -6 -25 -15 0 -8 -9 -15 -20 -15 -11 0 -20 -7 -20 -15 0 -8 -9 -15 -20 -15 -11 0 -20 -4 -20 -10 0 -5 -7 -10 -15 -10 -8 0 -15 -4 -15 -10 0 -5 -7 -10 -15 -10 -10 0 -15 -10 -15 -31 0 -35 -3 -36 95 34 71 51 245 195 245 203 0 10 -67 3 -78 -8z",
                    }
                )
            ),
            el(
                'g',
                { 
                    fill: 'rgb(118,127,245)'
                },
                el(
                    'path',
                    { 
                        d: "M672 2549 c-299 -35 -551 -251 -637 -544 -18 -62 -16 -72 12 -60 10 5 21 7 26 7 4 -1 7 4 7 11 0 9 2 9 8 0 8 -13 52 -6 52 8 0 5 16 9 35 9 19 0 35 4 35 8 0 5 11 15 25 22 13 7 27 21 30 31 7 20 62 58 94 64 11 2 29 8 40 14 16 9 22 8 29 -6 9 -14 13 -11 28 21 13 26 33 46 62 61 38 21 140 105 126 105 -4 0 -1 7 6 15 7 9 18 14 24 12 6 -3 20 13 31 35 10 22 32 48 47 59 15 11 28 25 28 30 0 5 8 21 17 35 9 14 18 37 19 50 2 22 -1 24 -34 23 -20 -1 -70 -5 -110 -10z m58 -109 c-27 -39 -34 -39 -12 0 9 16 21 30 25 30 5 0 -1 -13 -13 -30z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M830 2550 c0 -5 5 -10 11 -10 5 0 8 -4 5 -8 -3 -5 1 -9 9 -9 13 0 12 4 -2 19 -18 21 -23 22 -23 8z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1179 2213 c-2 -5 -38 -16 -79 -26 -41 -10 -116 -38 -166 -63 -339 -167 -532 -558 -469 -950 10 -60 25 -129 35 -154 76 -191 77 -200 48 -242 -12 -18 -26 -34 -30 -36 -5 -2 -8 -10 -8 -18 0 -8 -3 -13 -8 -12 -12 4 -52 -22 -52 -33 0 -6 5 -7 10 -4 5 3 10 2 10 -4 0 -5 -9 -13 -21 -16 -11 -4 -33 -26 -48 -50 -27 -42 -58 -80 -93 -112 -9 -9 -14 -23 -10 -31 3 -10 1 -13 -6 -8 -7 4 -12 2 -12 -6 0 -7 -12 -24 -25 -37 -14 -13 -25 -28 -25 -33 0 -6 -11 -19 -25 -30 -14 -11 -25 -26 -25 -34 0 -9 -5 -13 -12 -9 -7 4 -5 0 4 -8 10 -8 15 -16 13 -19 -3 -3 5 -13 17 -24 22 -19 23 -19 8 1 -14 18 -14 19 2 6 10 -7 15 -17 13 -21 -7 -12 71 -76 147 -122 72 -44 149 -75 233 -93 l60 -12 28 29 c17 18 27 40 27 59 0 18 5 29 14 29 8 0 17 11 20 25 4 14 11 25 16 25 6 0 10 11 10 25 0 14 4 25 8 25 5 0 19 21 32 47 13 27 30 54 37 61 7 7 13 18 13 24 0 6 7 18 15 27 39 41 65 81 65 97 0 12 -21 31 -55 52 -183 110 -320 289 -387 502 -20 66 -23 95 -23 235 0 190 11 242 84 390 56 113 135 214 231 293 72 58 173 122 205 128 11 2 43 15 71 29 32 16 73 27 105 29 30 2 60 4 67 5 18 2 14 31 -5 31 -9 0 -27 9 -39 21 -12 11 -23 17 -25 12z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M980 465 c0 -20 5 -25 25 -25 14 0 25 -4 25 -10 0 -5 15 -10 34 -10 19 0 36 -4 38 -9 3 -10 111 -31 156 -31 38 0 26 28 -15 35 -78 13 -140 28 -200 51 l-63 23 0 -24z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1337 403 c-4 -3 -7 -22 -7 -41 0 -30 2 -33 15 -22 9 7 25 26 36 42 l20 28 -29 0 c-16 0 -32 -3 -35 -7z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1210 249 l0 -30 30 21 c44 31 45 40 6 40 -33 0 -36 -2 -36 -31z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1130 190 c0 -15 -7 -20 -25 -20 -16 0 -25 -6 -25 -15 0 -8 -9 -15 -20 -15 -11 0 -20 -7 -20 -15 0 -8 -9 -15 -20 -15 -11 0 -20 -4 -20 -10 0 -5 -7 -10 -15 -10 -9 0 -15 -9 -15 -25 0 -22 -4 -25 -35 -25 -28 0 -35 -4 -35 -20 0 -24 31 -27 54 -5 8 8 19 15 25 15 6 0 11 4 11 8 0 4 15 16 33 27 17 10 37 24 44 29 6 6 24 21 40 33 15 12 44 35 63 52 l35 30 -37 1 c-31 0 -38 -3 -38 -20z",
                    }
                )
            ),
            el(
                'g',
                { 
                    fill: 'rgb(110,117,236)'
                },
                el(
                    'path',
                    { 
                        d: "M1237 2202 c-10 -2 -14 -8 -10 -15 4 -8 1 -7 -9 1 -9 7 -19 9 -22 4 -3 -5 -27 -13 -53 -17 -119 -18 -270 -97 -381 -201 -119 -110 -195 -230 -246 -392 -37 -119 -32 -135 7 -20 97 279 328 491 615 564 52 13 105 24 118 24 17 0 24 6 24 19 0 23 -20 39 -43 33z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M473 1365 c0 -22 2 -30 4 -17 2 12 2 30 0 40 -3 9 -5 -1 -4 -23z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M715 671 c30 -33 154 -136 191 -157 18 -10 17 -12 -9 -45 -15 -19 -33 -41 -41 -49 -7 -8 -17 -25 -20 -37 -4 -13 -13 -23 -20 -23 -6 0 -12 -8 -13 -19 -2 -24 -38 -83 -46 -74 -4 3 -7 -6 -7 -21 0 -15 -9 -36 -20 -48 -10 -12 -17 -25 -14 -30 3 -4 -2 -8 -10 -8 -11 0 -16 -9 -16 -29 0 -18 -10 -42 -25 -58 -14 -15 -29 -33 -35 -40 -14 -17 62 -28 204 -28 87 0 120 3 123 13 3 6 9 12 13 12 5 0 21 11 36 25 15 14 33 25 40 25 8 0 14 5 14 10 0 6 7 13 15 17 9 3 32 20 52 37 137 117 203 179 235 218 l37 45 -107 6 c-207 12 -381 87 -544 234 -35 32 -49 42 -33 24z",
                    }
                )
            ),
            el(
                'g',
                { 
                    fill: 'rgb(109,196,150)'
                },
                el(
                    'path',
                    { 
                        d: "M1920 1955 c0 -5 23 -32 50 -61 28 -30 60 -73 71 -96 l20 -43 -6 40 c-7 44 -28 77 -72 115 -49 43 -63 53 -63 45z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1726 1515 c9 -14 27 -51 40 -82 19 -48 24 -53 24 -29 0 52 -20 101 -51 118 l-29 17 16 -24z",
                    }
                ),
                el(
                    'path',
                    { 
                        d: "M1743 1080 c-12 -22 -21 -40 -20 -40 1 0 20 7 42 15 22 8 58 14 81 15 57 0 139 -43 171 -91 30 -46 36 -46 23 0 -25 88 -105 141 -211 141 l-64 0 -22 -40z",
                    }
                )
            ),
            el(
                'g',
                { 
                    fill: 'rgb(86,176,180)'
                },
                el(
                    'path',
                    { 
                        d: "M1237 2202 c-16 -7 -16 -9 -2 -30 15 -20 24 -22 111 -22 216 0 411 -73 584 -219 l55 -46 -33 42 c-100 128 -290 238 -462 269 -79 14 -223 17 -253 6z",
                    }
                )
            )
        );

   var chartBuilderMapSelectToProps = function( select ) {
       if(select( 'core/blocks' ).getBlockType( 'chart-builder/chart' ).attributes.idner &&
          (select( 'core/blocks' ).getBlockType( 'chart-builder/chart' ).attributes.idner != undefined ||
           select( 'core/blocks' ).getBlockType( 'chart-builder/chart' ).attributes.idner != null ) ){
           return {
               charts: select( 'core/blocks' ).getBlockType( 'chart-builder/chart' ).attributes.idner,
               metaFieldValue: select( 'core/editor' )
                   .getEditedPostAttribute( 'meta' )
                   [ 'sidebar_plugin_meta_block_field' ]
           };
       }else{
           return {
               charts: __( "Something goes wrong please reload page" )
           };
       }
   }

       // var chartBuilderMetaBlockField = function( props ) {
       //     if ( ! props.charts ) {
       //         return __("Loading...");
       //     }
       //     if( typeof props.charts != "object"){
       //         return props.charts;
       //     }

       //     if ( props.charts.length === 0 ) {
       //         return __("There are no charts yet");
       //     }
       //     var charter = [];
       //     charter.push({ label: __("-Select chart-"), value: ''});
       //     for(let i in props.charts){
       //         let chartData = {
       //                 value: props.charts[i].id,
       //                 label: props.charts[i].title,
       //             }
       //         charter.push(chartData)
       //     }
       //     var aysElement = el(
       //         aysSelect, {
       //             className: 'ays_chart_builder_block_select',
       //             label: 'Select chart for adding to post content',
       //             value: props.metaFieldValue,
       //             onChange: function( content ) {
       //                 props.shortcode = "[ays_chart id="+content+"]";
       //                 props.metaFieldValue = parseInt(content);
       //                 let block = wp.blocks.createBlock( 'chart-builder/chart', {
       //                     shortcode: "[ays_chart id="+content+"]",
       //                     charts: props.charts,
       //                     metaFieldValue: parseInt(content)
       //                 } );
       //                 wp.data.dispatch( 'core/editor' ).insertBlocks( block );
       //             },
       //             options: charter
       //         },
       //     );
       //     return el(
       //         "div",
       //         {
       //             className: 'ays_chart_builder_block_container',
       //             key: "inspector",                        
       //         },
       //         aysElement
       //     );
       // }
       // var chartBuilderMetaBlockFieldWithData = withSelect( chartBuilderMapSelectToProps )( chartBuilderMetaBlockField );
       // if(wp.plugins){
       //     wp.plugins.registerPlugin( 'chart-builder-sidebar', {
       //         render: function() {
       //             return el( wp.editPost.PluginSidebar,
       //                 {
       //                     name: 'chart-builder',
       //                     icon: iconEl,
       //                     title: 'Chart Builder',
       //                 },
       //                 el( 'div',
       //                     { className: 'chart-builder-sidebar-content' },
       //                     el( chartBuilderMetaBlockFieldWithData )
       //                 )
       //             );
       //         }
       //     } );
       // }

    var supports = {
        customClassName: false
    };

    registerBlockType( 'chart-builder/chart', {
        title: __('Chart Builder'),
        category: 'common',
        icon: iconEl,
        supports: supports,
        edit: withSelect( function( select ) {
            if(select( 'core/blocks' ).getBlockType( 'chart-builder/chart' ).attributes.idner &&
               (select( 'core/blocks' ).getBlockType( 'chart-builder/chart' ).attributes.idner != undefined ||
                select( 'core/blocks' ).getBlockType( 'chart-builder/chart' ).attributes.idner != null ) ){
                return {
                    charts: select( 'core/blocks' ).getBlockType( 'chart-builder/chart' ).attributes.idner
                };
            }else{
                return {
                    charts: __( "Something goes wrong please reload page" )
                };
            }
        } )( function( props ) {

            if ( ! props.charts ) {
                return __("Loading...");
            }
            if( typeof props.charts != "object"){
                return props.charts;
            }

            if ( props.charts.length === 0 ) {
                return __("There are no charts yet");
            }
            var status = 0;
            if(props.attributes.metaFieldValue > 0){            
                status = 1;
            }
            
            var charter = [];
            charter.push({ label: __("Select chart"), value: ''});
            for(var i in props.charts){
                var chartData = {
                        value: props.charts[i].id,
                        label: props.charts[i].title,
                    }
                charter.push(chartData)
            }

            setTimeout(function(){
                var shortcodeInput = document.querySelectorAll('.ays_chart_shortcode_input input[type="text"]');
                if(shortcodeInput){
                    for(var si = 0; si < shortcodeInput.length; si++){
                        shortcodeInput[si].setAttribute('readonly', 'readonly');
                    }
                }
            }, 500);

            var aysElement = el(
                aysSelect, {
                    className: 'ays_chart_builder_block_select',
                    label: 'Select chart',
                    value: props.attributes.metaFieldValue,
                    onChange: function( content ) {
                        var c = content;
                        var shortcodeText = '';
                        if(isNaN(content)){
                            c = '';
                        }

                        if( c != '' ){
                            shortcodeText = "[ays_chart id="+c+"]";
                        }else{
                            shortcodeText = '';
                            c = 0;
                        }
                        status = 1;
                        wp.data.dispatch( 'core/editor' ).updateBlockAttributes( props.clientId, {
                            shortcode: shortcodeText,
                            metaFieldValue: parseInt(c)
                        } );
                    },
                    options: charter
                }
            );

            var aysElement2 = el(
                aysSelect, {
                    className: 'ays_chart_builder_block_select',
                    label: '',
                    value: props.attributes.metaFieldValue,
                    onChange: function( content ) {
                        var c = content;
                        var shortcodeText = '';
                        if(isNaN(content)){
                            c = '';
                        }
                        if( c != '' ){
                            shortcodeText = "[ays_chart id="+c+"]";
                        }else{
                            shortcodeText = '';
                            c = 0;
                        }
                        wp.data.dispatch( 'core/editor' ).updateBlockAttributes( props.clientId, {
                            shortcode: shortcodeText,
                            metaFieldValue: parseInt(c)
                        } );

                        // return 
                    },
                    options: charter
                },
                // el(ServerSideRender, {
                //     key: "editable",
                //     block: "chart-builder/chart",
                //     attributes: props.attributes
                // })
            );
            var res = el(
                wp.element.Fragment,
                {},
                el(
                    BlockControls,
                    props
                ),
                el(
                    wp.editor.InspectorControls,
                    {},
                    el(
                        wp.components.PanelBody,
                        {},
                        el(
                            'div', {
                                className: 'ays_chart_builder_block_container'
                            }, null,
                            aysElement,
                        ),
                    ),
                ),
                // el(ServerSideRender, {
                //     key: "editable",
                //     block: "chart-builder/chart",
                //     attributes:  props.attributes
                // }),
                el(
                    "div",
                    {
                        className: 'ays_chart_builder_block_select_chart',
                        key: "inspector",
                    },
                    aysElement2
                ),
                el(
                    Text,
                    {
                        className: 'ays_chart_shortcode_input',
                        label: el( 'p', { style: { margin: 0 } },
                                  el('span', {
                                        style: {
                                            display: 'inline-block',
                                            'font-size': '14px',
                                            'margin-right': '6px',
                                        }
                                    }, "Chart Shortcode"),
                                  el( Dashicon, { 
                                    icon: "shortcode",
                                    className: 'svg_shortcode',
                                } ) ),
                        value: props.attributes.shortcode
                    },
                ),
            );
            var res2 = el(
                wp.element.Fragment,
                {},
                el(
                    BlockControls,
                    props
                ),
                el(
                    wp.editor.InspectorControls,
                    {},
                    el(
                        wp.components.PanelBody,
                        {},
                        el(
                            'div', {
                                className: 'ays_chart_builder_block_container'
                            }, null,
                            aysElement,
                        ),
                    ),
                ),
                // el(ServerSideRender, {
                //     key: "editable",
                //     block: "chart-builder/chart",
                //     attributes:  props.attributes
                // }),
                el(
                    "div",
                    {
                        className: 'ays_chart_builder_block_select_chart',
                        key: "inspector",
                    },
                    aysElement2
                ),
                el(
                    Text,
                    {
                        className: 'ays_chart_shortcode_input',
                        label: el( 'p', { style: { margin: 0 } },
                                  el('span', {
                                        style: {
                                            display: 'inline-block',
                                            'font-size': '14px',
                                            'margin-right': '6px',
                                        }
                                    }, "Chart Shortcode"),
                                  el( Dashicon, { 
                                    icon: "shortcode",
                                    className: 'svg_shortcode',
                                } ) ),
                        value: props.attributes.shortcode
                    },
                ),
            );
            if(status == 1){
                return res2;
            }else{
                return res;
            }
        }),

        save: function(e) {
            // var t = e.attributes,
            //     n = parseInt( t.metaFieldValue );

            // if(isNaN(n)){
            //     n = 0;
            // }

            // resolveBlocks();

            // return n ? el("div", null, '[ays_chart id="'+n+'"]') : null
            return null;
        }
    } );

    function resolveBlocks(id){
        var blocks = id ?
            select('core/block-editor').getBlock(id).innerBlocks
            : select('core/block-editor').getBlocks();

        if ( Array.isArray(blocks) ) {
            blocks.map( function(block){
                if(block.name == 'chart-builder/chart'){
                    if (!block.isValid) {
                        var newBlock = createBlock( block.name, block.attributes, block.innerblocks);
                        dispatch('core/block-editor').createBlock( block.clientId, newBlock );
                    } else {
                        resolveBlocks(block.clientId);
                    };
                }
            } );
        };
    };
})(wp);
