<?php
    if (isset($_GET['ays_chart_tab'])) {
        $ays_chart_tab = esc_attr($_GET['ays_chart_tab']);
    } else {
        $ays_chart_tab = 'tab1';
    }
    $action = isset( $_GET['action'] ) ? sanitize_text_field( $_GET['action'] ) : '';

    $id = (isset($_GET['id'])) ? absint( esc_attr($_GET['id']) ) : 0;

    $html_name_prefix = 'ays_';
    $html_class_prefix = 'ays-chart-';

    $user_id = get_current_user_id();
    $user = get_userdata($user_id);

    $options = array(

    );

    $chart_types = array(
        'line_chart'   => "Line Chart",
        'bar_chart'    => "Bar Chart",
        'pie_chart'    => "Pie Chart",
        'column_chart' => "Column Chart",
    );

    $chart_types_names = array(
        'line_chart'   => "Line",
        'bar_chart'    => "Bar",
        'pie_chart'    => "Pie",
        'column_chart' => "Column",
    );

    $object = array(
        'title' => '',
        'description' => '',
        'type' => 'google-charts',
        'source_chart_type' => 'pie_chart',
        'source_type' => 'manual',
        'source' => '',
        'status' => 'published',
        'date_created' => current_time( 'mysql' ),
        'date_modified' => current_time( 'mysql' ),
        'options' => json_encode( $options ),
    );

    $chart_data = array(
        'chart' => $object,
        'source_type' => 'manual',
        'source' => '',
        'settings' => array(),
        'options' => array(),
    );

    $quiz_queries = array(
        'q1' => __("The number of times all the users have passed the particular quiz", "chart-builder"),
        'q2' => __("The number of times the current user has passed all quizzes daily", "chart-builder"),
        'q3' => __("The number of times the current user has passed the current quiz", "chart-builder"),
        'q4' => __("The average score of current user of each quiz", "chart-builder"),
        'q5' => __("The number of times the current user has passed each quiz overall", "chart-builder"),
        'q6' => __("The current user's scores of the chosen quiz (PRO)", "chart-builder"),
        'q7' => __("The average scores of current user of the quizzes for each quiz category (PRO)", "chart-builder"),
        'q8' => __("The number of times the user passed the chosen category quizzes (PRO)", "chart-builder"),
        'q9' => __("The number of people who got the particular score (PRO)", "chart-builder"),
        'q10' => __("The number of people based on the particular Interval score (PRO)", "chart-builder"),
        'q11' => __("The count of the logged-in users and guests for the last 7 days (PRO)", "chart-builder"),
        'q12' => __("The answers count for each question of the chosen quiz (PRO)", "chart-builder"),
        'q13' => __("The answers count of the chosen quiz/question category (PRO)", "chart-builder"),
        'q14' => __("The number of times all the users passed all the quizzes for the last 7 days (PRO)", "chart-builder")
    );

	$tooltip_trigger_options = array(
		"hover" => __("While hovering", "chart-builder"),
		"selection" => __("When selected", "chart-builder"),
		"none" => __("Disable", "chart-builder")
	);
    
    $tooltip_text_options = array(
		"value" => __("Value", "chart-builder"),
		"percentage" => __("Percent", "chart-builder"),
		"both" => __("Value & Percent", "chart-builder")
	);

    $focus_target_options = array(
		"datum" => __("Single data", "chart-builder"),
		"category" => __("Group data", "chart-builder"),
	);

    $legend_positions = array(
        "left" => __("Left of the chart", "chart-builder"),
		"right" => __("Right of the chart", "chart-builder"),
		"top" => __("Above the chart", "chart-builder"),
		"bottom" => __("Below the chart", "chart-builder"),
		"in" => __("Inside the chart", "chart-builder"),
		"labeled" => __("Labeled", "chart-builder"),
		"none" => __("Omit the legend", "chart-builder")
	);

    $legend_alignments = array(
        "start" => __("Start", "chart-builder"),
		"center" => __("Center", "chart-builder"),
		"end" => __("End", "chart-builder"),
	);

    $slice_texts = array(
        "percentage" => __("Percentage", "chart-builder"),
		"value" => __("Quantitative value", "chart-builder"),
		"label" => __("Name", "chart-builder"),
		"none" => __("Disable", "chart-builder")
	);
    
    $axes_text_positions = array(
        "in" => __("Inside the chart", "chart-builder"),
		"out" => __("Outside the chart", "chart-builder"),
		"none" => __("Hide", "chart-builder")
	);

    $haxis_slanted_options = array(
        "automatic" => __("Automatic", "chart-builder"),
		"true" => __("True", "chart-builder"),
		"false" => __("False", "chart-builder")
	);

    $title_positions = array(
        "left" => __("Left", "chart-builder"),
		"right" => __("Right", "chart-builder"),
		"center" => __("Center", "chart-builder")
	);

	$chart_source_default_data = CBActions()->get_charts_default_data();

    $heading = '';
    switch ($action) {
        case 'add':
            $heading = __( 'Add new chart', "chart-builder" );
            break;
        case 'edit':
            $heading = __( 'Edit chart', "chart-builder" );
            $object = $this->db_obj->get_item( $id );
            $chart_data = CBActions()->get_chart_data( $id );
            break;
    }

    if( isset( $_POST['ays_submit'] ) || isset( $_POST['ays_submit_top'] ) ) {
        $this->db_obj->add_or_edit_item( $id );
    }

    if( isset( $_POST['ays_apply'] ) || isset( $_POST['ays_apply_top'] ) ){
        $_POST['save_type'] = 'apply';
        $this->db_obj->add_or_edit_item( $id );
    }

    if( isset( $_POST['ays_save_new'] ) || isset( $_POST['ays_save_new_top'] ) ){
        $_POST['save_type'] = 'save_new';
        $this->db_obj->add_or_edit_item( $id );
    }


    $loader_iamge = '<span class="display_none ays_chart_loader_box"><img src="'. CHART_BUILDER_ADMIN_URL .'/images/loaders/loading.gif"></span>';

    /**
     * Data that need to get form @object variable
     *
     * @object is a data directly from database
     */

    // Date created
    $date_created = isset( $object['date_created'] ) && CBFunctions()->validateDate( $object['date_created'] ) ? esc_attr($object['date_created']) : current_time( 'mysql' );

    // Date modified
    $date_modified = current_time( 'mysql' );


    /**
     * Data that need to get form @chart_data variable
     */



    /**
     * Data that need to get form @chart variable
     */

    // Chart
    $chart = $chart_data['chart'];

    // Source
    $source = isset($chart_data['source']) && $chart_data['source'] != '' ? $chart_data['source'] : $chart_source_default_data;

    // Source type
    $source_type = stripslashes( $chart['source_type'] );

    // Chart type
    $source_chart_type = stripslashes( $chart['source_chart_type'] );

    // Title
    $title = stripcslashes( $chart['title'] );

    // Description
    $description = stripcslashes( $chart['description'] );

    // Status
    $status = stripslashes( $chart['status'] );

    // Quiz query
    $quiz_query = isset($chart_data['quiz_query']) ? stripslashes($chart_data['quiz_query']) : '';

    // Quiz id
    $quiz_id = isset($chart_data['quiz_id']) ? intval($chart_data['quiz_id']) : 0;

    // Change the author of the current chart
    $change_create_author = (isset($chart['author_id']) && $chart['author_id'] != '') ? absint( sanitize_text_field( $chart['author_id'] ) ) : $user_id;

    if ( $change_create_author  && $change_create_author > 0 ) {
        global $wpdb;
        $users_table = esc_sql( $wpdb->prefix . 'users' );
        $sql_users = "SELECT ID, display_name FROM {$users_table} WHERE ID = {$change_create_author}";

        $create_author_data = $wpdb->get_row($sql_users, "ARRAY_A");
    } else {
        $change_create_author = $user_id;
        $create_author_data = array(
            "ID" => $user_id,
            "display_name" => $user->data->display_name,
        );
    }

    /**
     * Data that need to get form @settings variable
     */

    // Settings
    $settings = $chart_data['settings'];

    // Width
	$settings['width'] = isset( $settings['width'] ) && $settings['width'] != '' ? esc_attr( $settings['width'] ) : '100';

    // Height
	$settings['height'] = isset( $settings['height'] ) && $settings['height'] != '' ? esc_attr( $settings['height'] ) : '400';

    // Font size
	$settings['font_size'] = isset( $settings['font_size'] ) && $settings['font_size'] != '' ? esc_attr( $settings['font_size'] ) : '15';

	// Title color
	$settings['title_color'] = isset( $settings['title_color'] ) && $settings['title_color'] != '' ? esc_attr( $settings['title_color'] ) : '#000000';

    // Title font size
	$settings['title_font_size'] = isset( $settings['title_font_size'] ) && $settings['title_font_size'] != '' ? esc_attr( $settings['title_font_size'] ) : '30';

    // Title position
    $settings['title_position'] = isset( $settings['title_position'] ) && $settings['title_position'] != '' ? esc_attr( $settings['title_position'] ) : 'left';
	$settings['title_positions'] = $title_positions;

    // description color
	$settings['description_color'] = isset( $settings['description_color'] ) && $settings['description_color'] != '' ? esc_attr( $settings['description_color'] ) : '#4c4c4c';
    
    // description font size
	$settings['description_font_size'] = isset( $settings['description_font_size'] ) && $settings['description_font_size'] != '' ? esc_attr( $settings['description_font_size'] ) : '16';

    // Rotation degree
	$settings['rotation_degree'] = isset( $settings['rotation_degree'] ) && $settings['rotation_degree'] != '' ? esc_attr( $settings['rotation_degree'] ) : '0';

    // Is stacked
    $settings['is_stacked'] = ( isset( $settings['is_stacked'] ) && $settings['is_stacked'] != '' ) ? $settings['is_stacked'] : 'off';
    $settings['is_stacked'] = isset( $settings['is_stacked'] ) && $settings['is_stacked'] == 'on' ? 'checked' : '';

    // Line width
	$settings['line_width'] = isset( $settings['line_width'] ) && $settings['line_width'] != '' ? esc_attr( $settings['line_width'] ) : '2';

    // Slice border color
	$settings['slice_border_color'] = isset( $settings['slice_border_color'] ) && $settings['slice_border_color'] != '' ? esc_attr( $settings['slice_border_color'] ) : '#ffffff';

    // Reverse categories
    $settings['reverse_categories'] = ( isset( $settings['reverse_categories'] ) && $settings['reverse_categories'] != '' ) ? $settings['reverse_categories'] : 'off';
    $settings['reverse_categories'] = isset( $settings['reverse_categories'] ) && $settings['reverse_categories'] == 'on' ? 'checked' : '';

    // Slice text
    $settings['slice_text'] = isset( $settings['slice_text'] ) && $settings['slice_text'] != '' ? esc_attr( $settings['slice_text'] ) : 'percentage';
	$settings['slice_texts'] = $slice_texts;

	// Tooltip trigger
	$settings['tooltip_trigger'] = isset( $settings['tooltip_trigger'] ) && $settings['tooltip_trigger'] != '' ? esc_attr( $settings['tooltip_trigger'] ) : 'hover';
	$settings['tooltip_trigger_options'] = $tooltip_trigger_options;
    
    // Tooltip text
	$settings['tooltip_text'] = isset( $settings['tooltip_text'] ) && $settings['tooltip_text'] != '' ? esc_attr( $settings['tooltip_text'] ) : 'both';
	$settings['tooltip_text_options'] = $tooltip_text_options;

    // Focus target
    $settings['focus_target'] = isset( $settings['focus_target'] ) && $settings['focus_target'] != '' ? esc_attr( $settings['focus_target'] ) : 'datum';
    $settings['focus_target_options'] = $focus_target_options;

	// Show color code
	$settings['show_color_code'] = ( isset( $settings['show_color_code'] ) && $settings['show_color_code'] != '' ) ? $settings['show_color_code'] : 'off';
	$settings['show_color_code'] = isset( $settings['show_color_code'] ) && $settings['show_color_code'] == 'on' ? 'checked' : '';

    // Tooltip text color
    $settings['tooltip_text_color'] = isset( $settings['tooltip_text_color'] ) && $settings['tooltip_text_color'] != '' ? esc_attr( $settings['tooltip_text_color'] ) : '#000000';

	$settings['colors'] = ['#3366cc', '#dc3912', '#ff9900', '#109618', '#990099', '#0099c6', '#dd4477', '#66aa00', '#b82e2e', '#316395'];

    // Legend position
    $settings['legend_position'] = isset( $settings['legend_position'] ) && $settings['legend_position'] != '' ? esc_attr( $settings['legend_position'] ) : 'right';
	$settings['legend_positions'] = $legend_positions;

    // Legend alignment
    $settings['legend_alignment'] = isset( $settings['legend_alignment'] ) && $settings['legend_alignment'] != '' ? esc_attr( $settings['legend_alignment'] ) : 'start';
	$settings['legend_alignments'] = $legend_alignments;

    // Legend font color
	$settings['legend_color'] = isset( $settings['legend_color'] ) && $settings['legend_color'] != '' ? esc_attr( $settings['legend_color'] ) : '#000000';

    // Opacity
	$settings['opacity'] = isset( $settings['opacity'] ) && $settings['opacity'] != '' ? esc_attr( $settings['opacity'] ) : '1.0';

    // Show chart title
    if (!isset($settings['show_title'])) {
        $settings['show_title'] = 'checked';
    } else {
        $settings['show_title'] = ( $settings['show_title'] != '' ) ? $settings['show_title'] : 'off';
	    $settings['show_title'] = isset( $settings['show_title'] ) && $settings['show_title'] == 'on' ? 'checked' : '';
    }
	
    $settings['axes_text_positions'] = $axes_text_positions;
    // Horizontal axis settings
    $settings['haxis_title'] = isset( $settings['haxis_title'] ) && $settings['haxis_title'] != '' ? esc_attr( $settings['haxis_title'] ) : '';
    $settings['haxis_text_position'] = isset( $settings['haxis_text_position'] ) && $settings['haxis_text_position'] != '' ? esc_attr( $settings['haxis_text_position'] ) : 'out';
	$settings['haxis_direction'] = ( isset( $settings['haxis_direction'] ) && $settings['haxis_direction'] != '' ) ? $settings['haxis_direction'] : '1';
	$settings['haxis_direction'] = isset( $settings['haxis_direction'] ) && $settings['haxis_direction'] == '-1' ? 'checked' : '';
    $settings['haxis_text_color'] = isset( $settings['haxis_text_color'] ) && $settings['haxis_text_color'] != '' ? esc_attr( $settings['haxis_text_color'] ) : '#000000';
    $settings['haxis_slanted_options'] = $haxis_slanted_options;
    $settings['haxis_slanted'] = isset( $settings['haxis_slanted'] ) && $settings['haxis_slanted'] != '' ? esc_attr( $settings['haxis_slanted'] ) : 'automatic';
    $settings['haxis_slanted_text_angle'] = isset( $settings['haxis_slanted_text_angle'] ) && $settings['haxis_slanted_text_angle'] != '' && $settings['haxis_slanted_text_angle'] != '0' ? esc_attr( $settings['haxis_slanted_text_angle'] ) : '30';

    // Vertical axis settings
    $settings['vaxis_title'] = isset( $settings['vaxis_title'] ) && $settings['vaxis_title'] != '' ? esc_attr( $settings['vaxis_title'] ) : '';
    $settings['vaxis_text_position'] = isset( $settings['vaxis_text_position'] ) && $settings['vaxis_text_position'] != '' ? esc_attr( $settings['vaxis_text_position'] ) : 'out';
	$settings['vaxis_direction'] = ( isset( $settings['vaxis_direction'] ) && $settings['vaxis_direction'] != '' ) ? $settings['vaxis_direction'] : '1';
	$settings['vaxis_direction'] = isset( $settings['vaxis_direction'] ) && $settings['vaxis_direction'] == '-1' ? 'checked' : '';
    $settings['vaxis_text_color'] = isset( $settings['vaxis_text_color'] ) && $settings['vaxis_text_color'] != '' ? esc_attr( $settings['vaxis_text_color'] ) : '#000000';

    // Animation settings
    $settings['enable_animation'] = ( isset( $settings['enable_animation'] ) && $settings['enable_animation'] != '' ) ? $settings['enable_animation'] : 'off';
	$settings['enable_animation'] = isset( $settings['enable_animation'] ) && $settings['enable_animation'] == 'on' ? 'checked' : '';

    $settings['animation_duration'] = isset( $settings['animation_duration'] ) && $settings['animation_duration'] != '' ? absint(esc_attr( $settings['animation_duration'] )) : '1000';

/**
     * Data that need to get form @options variable
     */

    // Options
    $options = $object['options'];

    // Send data to JS
    $source_data_for_js = array(
        'source' => $source,
        'action' => $action,
        'settings' => $settings,
        'chartType' => $source_chart_type,
        'chartTypesNames' => $chart_types_names,
        'addManualDataRow' => CHART_BUILDER_ADMIN_URL . '/images/icons/add-circle-outline.svg',
        // 'removeManualDataRow' => CHART_BUILDER_ADMIN_URL . '/images/icons/xmark.svg',
    );
    wp_localize_script($this->plugin_name, "ChartBuilderSourceData" , $source_data_for_js);