(function($) {
    'use strict';
    function AysChartBuilder(element, options){
        this.el = element;
        this.$el = $(element);
        this.ajaxAction = 'ays_chart_admin_ajax';
        this.htmlClassPrefix = 'ays-chart-';
        this.htmlNamePrefix = 'ays_';
        this.dbOptions = undefined;
        this.chartSourceData = undefined;
		this.chartObj = undefined;
		this.chartOptions = null;
		this.chartData = null;
		this.chartTempData = null;

		this.chartSources = {
			'line_chart'   : 'Line Chart',
			'bar_chart'    : 'Bar Chart',
			'pie_chart'    : 'Pie Chart',
			'column_chart' : 'Column Chart'
		}

        this.init();

        return this;
    }

    AysChartBuilder.prototype.init = function() {
        var _this = this;
		_this.chartSourceData = window.ChartBuilderSourceData;
        _this.setEvents();
        _this.initLibraries();
        _this.setAccordionEvents();

		_this.initDbImport();
		_this.initQuizDBImport();
    };

	// Set events
    AysChartBuilder.prototype.setEvents = function(e){
        var _this = this;
		/* == Choose poll type from modal == */
			_this.$el.on('dblclick'  , '.'+_this.htmlClassPrefix+'layer_box_blocks label.'+_this.htmlClassPrefix+'dblclick-layer:not(.'+_this.htmlClassPrefix+'type-pro-feature)', function(){
				_this.$el.find('.'+_this.htmlClassPrefix+'select_button_layer input.'+_this.htmlClassPrefix+'layer_button').trigger('click');
			}); 

			_this.$el.on('change'  , '.'+_this.htmlClassPrefix+'choose-source', function(){
				_this.$el.find('.'+_this.htmlClassPrefix+'select_button_layer input.'+_this.htmlClassPrefix+'layer_button').prop('disabled',false).attr("data-type" , $(this).val());
				// _this.$el.find('#poll_choose_type').val($(this).val());
			}); 
			
			_this.$el.on('click', '.'+_this.htmlClassPrefix+'layer_button' ,function(){
				var getCheckedChartTpye = _this.$el.find('.'+_this.htmlClassPrefix+'choose-source:checked').val();
				_this.$el.find('.'+_this.htmlClassPrefix+'layer_container').css({'position':'unset' , 'display':'none'});
				_this.$el.find('.'+_this.htmlClassPrefix+'type-info-box-text-changeable').text(_this.chartSources[getCheckedChartTpye]);
				_this.$el.find('.'+_this.htmlClassPrefix+'nav-tab-chart.nav-tab[data-tab="tab3"]').text(_this.chartSourceData.chartTypesNames[getCheckedChartTpye]+" settings");
				_this.$el.find('.'+_this.htmlClassPrefix+'advanced-settings legend.ays-accordion-options-header span').text(_this.chartSourceData.chartTypesNames[getCheckedChartTpye]+" settings");
				_this.$el.find('#'+_this.htmlClassPrefix+'option-chart-type').val(getCheckedChartTpye);
				_this.$el.find('.'+_this.htmlClassPrefix+'charts-main-container').attr('id' , _this.htmlClassPrefix+getCheckedChartTpye);
				_this.loadChartBySource( getCheckedChartTpye );
				_this.configureOptions( getCheckedChartTpye );
			});
		/* */

		/* == Tabulation == */
			_this.$el.on('click', '.nav-tab-wrapper a.nav-tab' , _this.changeTabs);
		/* */

		// /* == Range slider functions == */
		// _this.$el.on('input', '#ays-chart-option-font-size', _this.rangeSliderChange);
		// _this.$el.on('mouseenter', '#ays-chart-option-font-size', function(e) {
		// 	$('#ays-chart-range-value').show();
		// });
		// _this.$el.on('mouseleave', '#ays-chart-option-font-size', function(e) {
		// 	$('#ays-chart-range-value').hide();
		// });
		// /* */

		/* == Notifications dismiss button == */
			_this.$el.on('click', '.notice-dismiss', function (e) {
				_this.changeCurrentUrl('status');
			});

			_this.$el.on('click', '.toggle_ddmenu' , _this.toggleDDmenu);
		/* */

		/* Add Manual data */
			_this.$el.on("click"  , '.'+_this.htmlClassPrefix+'add-new-row-box', function(){
				_this.addChartDataRow();
			});

			_this.$el.on("click"  , '.'+_this.htmlClassPrefix+'add-new-column-box', function(){
				_this.addChartDataColumn();
			});

			_this.$el.on('click', '.'+_this.htmlClassPrefix+'show-on-chart-bttn', function(e){		
				var loadedChartType = _this.$el.find('.'+_this.htmlClassPrefix+'choose-source:checked').val();
				var chartType = (loadedChartType === undefined) ? _this.chartSourceData.chartType : loadedChartType;
				e.preventDefault();
				_this.showOnChart($(this), chartType);
			});

		/* */

		/* Delete data */ 
			_this.$el.on("click"  , '.'+_this.htmlClassPrefix+'chart-source-data-remove-row', function(){
				_this.deleteChartDataRow($(this));
				_this.detectManualChange();
			});
			_this.$el.on("click"  , '.'+_this.htmlClassPrefix+'chart-source-data-remove-col', function(){
				_this.deleteChartDataColumn($(this));
				_this.detectManualChange();
			});
			_this.$el.on('mouseenter', '.'+_this.htmlClassPrefix+'chart-source-data-remove-block', function() {
				$(this).find('path').css('fill', '#ff0000');
			});
			_this.$el.on('mouseleave', '.'+_this.htmlClassPrefix+'chart-source-data-remove-block', function() {
				$(this).find('path').css('fill', '#b8b8b8');
			});
		/* */

		/* Load data on the edit page */ 
		if(_this.chartSourceData.action == 'edit'){
			_this.loadChartBySource( _this.chartSourceData.chartType );
			_this.configureOptions( _this.chartSourceData.chartType );
		}
		/* */

		/* Save with Ctrl + S */
		_this.$el.on('keydown', $(document), _this.quickSaveHotKeys);
		/* */

		// Submit buttons disabling
		_this.$el.on('click', '.'+_this.htmlClassPrefix+'loader-banner', _this.submitOnce);
		/* */
		
		// Disabling submit when press enter button on inputing
		$(document).on("keypress", '.ays-text-input', _this.disableSubmit);
		/* */

		// Modal close
		$(document).on('click', '.ays-close', function () {
			$(this).parents('.ays-modal').aysModal('hide');
		});

		// Changing source type to manual
		_this.$el.on('input', '.'+_this.htmlClassPrefix+'chart-source-data-content input', function () {
			_this.detectManualChange();
		});

		// Shortcode text for editor tooltip
		$(document).find('strong.ays-chart-shortcode-box').on('mouseleave', function(){
			var _this = $(this);
	
			_this.attr('data-original-title', aysChartBuilderAdmin.clickForCopy);
			_this.attr("data-bs-original-title", aysChartBuilderAdmin.clickForCopy);
			_this.attr("title", aysChartBuilderAdmin.clickForCopy);
		});

		// Quiz maker integration
		$(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-data-query').on('change', function () {
			var option = $(this).find('option:selected');
			if (option.attr('is-pro') == "true") {
				$(this).find('option[value=""]').prop('selected', true);
				window.open('https://ays-pro.com/wordpress/chart-builder/', '_blank');
			} else {
				_this.quizMakerIntegrationConfig();
				_this.toggleQuizSelect(this);
			}
		});

		$(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-quiz').on('change', function () {
			_this.quizMakerIntegrationConfig();
		});

		$(window).on('load', function () {
			_this.toggleQuizSelect();
		});

		$(document).find('#'+_this.htmlClassPrefix+'option-haxis-slanted-text').on('change', function () {
			var angleOption = $(document).find('#'+_this.htmlClassPrefix+'option-haxis-slanted-text-angle').parents('.'+_this.htmlClassPrefix+'options-section');
			if ($(this).val() !== 'false') {
				angleOption.removeClass('display_none');
			} else {
				angleOption.addClass('display_none');
			}
		});

		$(document).find('#'+_this.htmlClassPrefix+'option-enable-animation').on('change', function () {
			var duration = $(document).find('#'+_this.htmlClassPrefix+'option-animation-duration').parents('.'+_this.htmlClassPrefix+'options-section');
			if ($(this).is(':checked')) {
				duration.removeClass('display_none');
			} else {
				duration.addClass('display_none');
			}
		});

		// Live preview
		_this.liveSettingsPreview();
    }

	AysChartBuilder.prototype.liveSettingsPreview = function () {
		var _this = this;

		// general settings
			_this.$el.find('#'+_this.htmlClassPrefix+'option-width').on('input', function () {
				_this.$el.find('.'+_this.htmlClassPrefix+'charts-main-container').css('width', $(this).val()+'%');
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-height').on('input', function () {
				_this.$el.find('.'+_this.htmlClassPrefix+'charts-main-container').css('height', $(this).val()+'px');
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-font-size').on('input', function () {
				_this.chartOptions.fontSize = $(this).val();
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});
			
		// tooltip settings
			_this.$el.find('#'+_this.htmlClassPrefix+'option-tooltip-trigger').on('change', function () {
				_this.chartOptions.tooltip.trigger = $(this).val();
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-show-color-code').on('change', function () {
				_this.chartOptions.tooltip.showColorCode = $(this).is(':checked');
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});

		// legend settings
			_this.$el.find('#'+_this.htmlClassPrefix+'option-legend-position').on('change', function () {
				_this.chartOptions.legend.position = $(this).val();
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-legend-alignment').on('change', function () {
				_this.chartOptions.legend.alignment = $(this).val();
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-legend-font-color').on('input', function () {
				_this.chartOptions.legend.textStyle.color = $(this).val();
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});

		// horizontal axis settings
			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-title').on('input', function () {
				_this.chartOptions.hAxis.title = $(this).val();
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-text-position').on('change', function () {
				_this.chartOptions.hAxis.textPosition = $(this).val();
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-text-direction').on('change', function () {
				_this.chartOptions.hAxis.direction = $(this).is(':checked') ? -1 : 1;
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-text-color').on('input', function () {
				_this.chartOptions.hAxis.textStyle.color = $(this).val();
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-slanted-text').on('change', function () {
				_this.chartOptions.hAxis.slantedText = $(this).val();
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-haxis-slanted-text-angle').on('input', function () {
				_this.chartOptions.hAxis.slantedTextAngle = $(this).val() != 0 ? $(this).val() : 30;
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});

		// vertical axis settings
			_this.$el.find('#'+_this.htmlClassPrefix+'option-vaxis-title').on('input', function () {
				_this.chartOptions.vAxis.title = $(this).val();
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-vaxis-text-position').on('change', function () {
				_this.chartOptions.vAxis.textPosition = $(this).val();
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-vaxis-text-direction').on('change', function () {
				_this.chartOptions.vAxis.direction = $(this).is(':checked') ? -1 : 1;
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-vaxis-text-color').on('input', function () {
				_this.chartOptions.vAxis.textStyle.color = $(this).val();
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});

		// // animation settings
		// 	_this.$el.find('#'+_this.htmlClassPrefix+'option-enable-animation').on('change', function () {
		// 		_this.chartOptions.animation.startup = $(this).is(':checked');
		// 		_this.chartObj.draw(_this.chartData, _this.chartOptions);
		// 	});

		// 	_this.$el.find('#'+_this.htmlClassPrefix+'option-animation-duration').on('input', function () {
		// 		if (_this.$el.find('#'+_this.htmlClassPrefix+'option-enable-animation').is(':checked')) {
		// 			_this.chartOptions.animation.duration = $(this).val();
		// 			_this.chartObj.draw(_this.chartData, _this.chartOptions);
		// 		}
		// 	});

		// advanced settings
			_this.$el.find('#'+_this.htmlClassPrefix+'option-rotation-degree').on('input', function () {
				_this.chartOptions.pieStartAngle = $(this).val();
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-reverse-categories').on('change', function () {
				_this.chartOptions.reverseCategories = $(this).is(':checked');
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-slice-border-color').on('input', function () {
				_this.chartOptions.pieSliceBorderColor = $(this).val();
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-slice-text').on('change', function () {
				_this.chartOptions.pieSliceText = $(this).val();
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-tooltip-text').on('change', function () {
				_this.chartOptions.tooltip.text = $(this).val();
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-is-stacked').on('change', function () {
				_this.chartOptions.isStacked = $(this).is(':checked');
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-focus-target').on('change', function () {
				_this.chartOptions.focusTarget = $(this).val();
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});
			
			_this.$el.find('#'+_this.htmlClassPrefix+'option-opacity').on('input', function () {
				_this.chartOptions.dataOpacity = $(this).val();
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-tooltip-text-color').on('input', function () {
				_this.chartOptions.tooltip.textStyle.color = $(this).val();
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});

			_this.$el.find('#'+_this.htmlClassPrefix+'option-line-width').on('input', function () {
				_this.chartOptions.lineWidth = $(this).val();
				_this.chartObj.draw(_this.chartData, _this.chartOptions);
			});
		
	}

	AysChartBuilder.prototype.toggleQuizSelect = function (e) {
		var _this = this;

		var select = $(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-data-query');
		var option = $(select).find('option:selected').val();
		var selectQuizSelect = $(document).find('.'+_this.htmlClassPrefix+'select-quiz-maker-quiz-container');

		if (option == 'q1' || option == 'q3') {
			selectQuizSelect.slideDown();
		} else {
			selectQuizSelect.slideUp();
		}
	}
	
	AysChartBuilder.prototype.quizMakerIntegrationConfig = function (e) {
		var _this = this;

		var input = $(document).find('input[name="ays_source_type"]');
		if (input.val() !== 'quiz_maker') input.val('quiz_maker');

		_this.$el.find('#ays-chart-quiz-maker-success').empty();
		_this.$el.find('#ays-chart-quiz-maker-error').empty();
	}

	AysChartBuilder.prototype.detectManualChange = function (e) {
		var input = $(document).find('input[name="ays_source_type"]');
		if (input.val() !== 'manual') input.val('manual'); 	
	}

	// Disabling submit when pressing enter button on input
	AysChartBuilder.prototype.disableSubmit = function(e){
		if(e.which == 13){
			if($(document).find("#ays-charts-form").length !== 0 || $(document).find("#ays-settings-form").length !== 0){
				return false;
			}
		}
	}

	// Change tabs (tabulation)
	AysChartBuilder.prototype.changeTabs = function(e){
		if(! $(this).hasClass('no-js')){
			var elemenetID = $(this).attr('href');
			var active_tab = $(this).attr('data-tab');
			$(document).find('.nav-tab-wrapper a.nav-tab').each(function () {
				if ($(this).hasClass('nav-tab-active')) {
					$(this).removeClass('nav-tab-active');
				}
			});
			$(this).addClass('nav-tab-active');
			$(document).find('.ays-tab-content').each(function () {
				$(this).removeClass('ays-tab-content-active');
			});
			$(document).find("[name='ays_chart_tab']").val(active_tab);
			$('.ays-tab-content' + elemenetID).addClass('ays-tab-content-active');
			e.preventDefault();
		}
	}

	// AysChartBuilder.prototype.rangeSliderChange = function(e){
	// 	var min = e.target.min;
	// 	var max = e.target.max;
	// 	var val = e.target.value;
	// 	var width = $('#ays-chart-option-font-size').width();

	// 	$(e.target).css('backgroundSize', (val - min) / (max - min) * 100 + '% 100%');

	// 	$('#ays-chart-range-value').css('left', 12.8 + (val - min) / (max - min + 1) * width + 'px');
	// 	$('#ays-chart-range-value span').html(val);
	// }

	AysChartBuilder.prototype.changeCurrentUrl = function(key){
		var linkModified = location.href.split('?')[1].split('&');
		for(var i = 0; i < linkModified.length; i++){
			if(linkModified[i].split("=")[0] == key){
				linkModified.splice(i, 1);
			}
		}
		linkModified = linkModified.join('&');
		window.history.replaceState({}, document.title, '?'+linkModified);
	}

	AysChartBuilder.prototype.toggleDDmenu = function(e){
		var ddmenu = $(this).next();
		var state = ddmenu.attr('data-expanded');
		switch (state) {
			case 'true':
				$(this).find('.ays_fa').css({
					transform: 'rotate(0deg)'
				});
				ddmenu.attr('data-expanded', 'false');
				break;
			case 'false':
				$(this).find('.ays_fa').css({
					transform: 'rotate(90deg)'
				});
				ddmenu.attr('data-expanded', 'true');
				break;
		}
	}

	AysChartBuilder.prototype.submitOnce = function(el) {
        setTimeout(function() {
			$(document).find('.ays-chart-loader-banner').attr('disabled', true);
        }, 50);

        setTimeout(function() {
            $(document).find('.ays-chart-loader-banner').attr('disabled', false);
        }, 5000);
	}

	// Load charts by given type main function
	AysChartBuilder.prototype.initLibraries = function (){
		var _this = this;
		
		var googleSelect = _this.$el.find('.' + _this.htmlClassPrefix + 'google-sheet-select');
		googleSelect.select2();
		var fileTypeSelect =  _this.$el.find('#' + _this.htmlClassPrefix + 'import-files-file-type');
		fileTypeSelect.select2();
		var quizQuerySelect =  _this.$el.find('#' + _this.htmlClassPrefix + 'select-quiz-maker-data-query');
		quizQuerySelect.select2();
		var quizQuizSelect =  _this.$el.find('#' + _this.htmlClassPrefix + 'select-quiz-maker-quiz');
		quizQuizSelect.select2();

		_this.$el.find('#ays-chart-option-create-author').select2({
			placeholder: aysChartBuilderAdmin.selectUser,
			minimumInputLength: 1,
			allowClear: true,
			language: {
				searching: function() {
					return aysChartBuilderAdmin.searching;
				},
				inputTooShort: function () {
					return aysChartBuilderAdmin.pleaseEnterMore;
				}
			},
			ajax: {
				url: ajaxurl,
				dataType: 'json',
				data: function (response) {
					var checkedUsers = _this.$el.find('#ays-chart-option-create-author').val();
					return {
						action: _this.ajaxAction,
						function: window.aysChartBuilderChartSettings.ajax['actions']['author_user_search'],
						security: window.aysChartBuilderChartSettings.ajax['nonces']['author_user_search'],
						params: {
							search: response.term,
							val: checkedUsers
						}
					};
				}
			}
		});
	}

	// Load charts by given type main function
	AysChartBuilder.prototype.loadChartBySource = function( chartType ){
		var _this = this;

		if( ! chartType ){
			chartType = _this.chartSourceData.chartType;
		}

		if(typeof chartType !== undefined && chartType){
			switch (chartType) {
				case 'pie_chart':
					_this.pieChartView( chartType );
					break;
				case 'bar_chart':
					_this.barChartView( chartType );
					break;
				case 'column_chart':
					_this.columnChartView( chartType );
					break;
				case 'line_chart':
					_this.lineChartView( chartType );
					break;
				default:
					_this.pieChartView( chartType );
					break;
			}
		}		
	}

	// Load chart by pie chart
	AysChartBuilder.prototype.pieChartView = function( chartType ){
		var _this = this;
		var getChartSource = _this.chartSourceData.source;

		var dataTypes = _this.chartConvertData( getChartSource );

		var settings = _this.chartSourceData.settings;
		var chartFontSize = settings['font_size'];
		var tooltipTrigger = settings['tooltip_trigger'];
		var tooltipText = settings['tooltip_text'];
		var showColorCode = (settings['show_color_code'] == 'checked') ? true : false;
		var tooltipTextColor = settings['tooltip_text_color'];
		var legendPosition = settings['legend_position'];
		var legendAlignment = settings['legend_alignment'];
		var rotationDegree = settings['rotation_degree'];
		var sliceBorderColor = settings['slice_border_color'];
		var reverseCategories = (settings['reverse_categories'] == 'checked') ? true : false;
		var sliceText = settings['slice_text'];
		var legendColor = settings['legend_color'];

		/* == Google part == */
		google.charts.load('current', {'packages':['corechart']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartData = google.visualization.arrayToDataTable( dataTypes );

			_this.chartOptions = {
				backgroundColor: 'transparent',
				fontSize: chartFontSize,
				legend: {
					position: legendPosition,
					alignment: legendAlignment,
					textStyle: {
						color: legendColor
					}
				},
				tooltip: { 
					trigger: tooltipTrigger,
					showColorCode: showColorCode,
					text: tooltipText,
					textStyle: {
						color: tooltipTextColor
					}
				},
				pieStartAngle: rotationDegree,
				pieSliceBorderColor: sliceBorderColor,
				reverseCategories: reverseCategories,
				pieSliceText: sliceText
			};

			_this.chartObj = new google.visualization.PieChart( document.getElementById(_this.htmlClassPrefix + chartType) );

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}

	// Load chart by bar chart
	AysChartBuilder.prototype.barChartView = function( chartType ){
		var _this = this;
		var getChartSource = _this.chartSourceData.source;
		var dataTypes = _this.multiColumnChartConvertData( getChartSource );

		var settings = _this.chartSourceData.settings;
		var chartFontSize = settings['font_size'];
		var isStacked = (settings['is_stacked'] == 'checked') ? true : false;
		var tooltipTrigger = settings['tooltip_trigger'];
		var focusTarget = settings['focus_target'];
		var showColorCode = (settings['show_color_code'] == 'checked') ? true : false;
		var tooltipTextColor = settings['tooltip_text_color'];
		var legendPosition = settings['legend_position'];
		var legendAlignment = settings['legend_alignment'];
		var legendColor = settings['legend_color'];
		var hAxisTitle = settings['haxis_title'];
		var vAxisTitle = settings['vaxis_title'];
		var hAxisTextPosition = settings['haxis_text_position'];
		var vAxisTextPosition = settings['vaxis_text_position'];
		var vAxisDirection = (settings['vaxis_direction'] == 'checked') ? -1 : 1;
		var hAxisDirection = (settings['haxis_direction'] == 'checked') ? -1 : 1;
		var hAxisTextColor = settings['haxis_text_color'];
		var vAxisTextColor = settings['vaxis_text_color'];
		var hAxisSlantedText = settings['haxis_slanted'];
		var hAxisSlantedTextAngle = settings['haxis_slanted_text_angle'];
		var opacity = settings['opacity'];

		var enableAnimation = (settings['enable_animation'] == 'checked') ? true : false;
		var animationDuration = settings['animation_duration'];

		/* == Google part == */
		google.charts.load('current', {'packages':['corechart']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartData = google.visualization.arrayToDataTable(dataTypes);

			_this.chartOptions = {
				backgroundColor: 'transparent',
				fontSize: chartFontSize,
				legend: {
					position: legendPosition,
					alignment: legendAlignment,
					textStyle: {
						color: legendColor
					}
				},
				tooltip: { 
					trigger: tooltipTrigger,
					showColorCode: showColorCode,
					textStyle: {
						color: tooltipTextColor
					}
				},
				hAxis: {
					title: hAxisTitle,
					textPosition: hAxisTextPosition,
					direction: hAxisDirection,
					textStyle: {
						color: hAxisTextColor
					},
					slantedText: hAxisSlantedText,
					slantedTextAngle: hAxisSlantedTextAngle
				},
				vAxis: {
					title: vAxisTitle,
					textPosition: vAxisTextPosition,
					direction: vAxisDirection,
					textStyle: {
						color: vAxisTextColor
					}
				},
				focusTarget: focusTarget,
				isStacked: isStacked,
				dataOpacity: opacity,
				animation: {
					startup: enableAnimation,
					duration: animationDuration,
        			easing: 'linear',
				}
			};

			_this.chartObj = new google.visualization.BarChart(document.getElementById(_this.htmlClassPrefix + chartType));

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}

	// Load chart by column chart
	AysChartBuilder.prototype.columnChartView = function( chartType ){
		var _this = this;
		var getChartSource = _this.chartSourceData.source;

		var dataTypes = _this.multiColumnChartConvertData( getChartSource );

		var settings = _this.chartSourceData.settings;
		var chartFontSize = settings['font_size'];
		var isStacked = (settings['is_stacked'] == 'checked') ? true : false;
		var tooltipTrigger = settings['tooltip_trigger'];
		var focusTarget = settings['focus_target'];
		var showColorCode = (settings['show_color_code'] == 'checked') ? true : false;
		var tooltipTextColor = settings['tooltip_text_color'];
		var legendPosition = settings['legend_position'];
		var legendAlignment = settings['legend_alignment'];
		var legendColor = settings['legend_color'];
		var hAxisTitle = settings['haxis_title'];
		var vAxisTitle = settings['vaxis_title'];
		var hAxisTextPosition = settings['haxis_text_position'];
		var vAxisTextPosition = settings['vaxis_text_position'];
		var vAxisDirection = (settings['vaxis_direction'] == 'checked') ? -1 : 1;
		var hAxisDirection = (settings['haxis_direction'] == 'checked') ? -1 : 1;
		var hAxisTextColor = settings['haxis_text_color'];
		var vAxisTextColor = settings['vaxis_text_color'];
		var hAxisSlantedText = settings['haxis_slanted'];
		var hAxisSlantedTextAngle = settings['haxis_slanted_text_angle'];
		var opacity = settings['opacity'];

		var enableAnimation = (settings['enable_animation'] == 'checked') ? true : false;
		var animationDuration = settings['animation_duration'];

		// Collect data in new array for chart rendering (Column chart)

		/* == Google part == */
		google.charts.load('current', {'packages':['corechart']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartData = google.visualization.arrayToDataTable(dataTypes);

			_this.chartOptions = {
				backgroundColor: 'transparent',
				fontSize: chartFontSize,
				legend: {
					position: legendPosition,
					alignment: legendAlignment,
					textStyle: {
						color: legendColor
					}
				},
				tooltip: { 
					trigger: tooltipTrigger,
					showColorCode: showColorCode,
					textStyle: {
						color: tooltipTextColor
					}
				},
				hAxis: {
					title: hAxisTitle,
					textPosition: hAxisTextPosition,
					direction: hAxisDirection,
					textStyle: {
						color: hAxisTextColor
					},
					slantedText: hAxisSlantedText,
					slantedTextAngle: hAxisSlantedTextAngle
				},
				vAxis: {
					title: vAxisTitle,
					textPosition: vAxisTextPosition,
					direction: vAxisDirection,
					textStyle: {
						color: vAxisTextColor
					}
				},
				focusTarget: focusTarget,
				isStacked: isStacked,
				dataOpacity: opacity,
				animation: {
					startup: enableAnimation,
					duration: animationDuration,
        			easing: 'linear',
				}
			};

			_this.chartObj = new google.visualization.ColumnChart(document.getElementById(_this.htmlClassPrefix + chartType));

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}

	// Load chart by line chart
	AysChartBuilder.prototype.lineChartView = function( chartType ){
		var _this = this;
		var getChartSource = _this.chartSourceData.source;
		var dataTypes = _this.multiColumnChartConvertData(getChartSource);

		var settings = _this.chartSourceData.settings;
		var chartFontSize = settings['font_size'];
		var tooltipTrigger = settings['tooltip_trigger'];
		var focusTarget = settings['focus_target'];
		var showColorCode = (settings['show_color_code'] == 'checked') ? true : false;
		var tooltipTextColor = settings['tooltip_text_color'];
		var legendPosition = settings['legend_position'];
		var legendAlignment = settings['legend_alignment'];
		var legendColor = settings['legend_color'];
		var hAxisTitle = settings['haxis_title'];
		var vAxisTitle = settings['vaxis_title'];
		var hAxisTextPosition = settings['haxis_text_position'];
		var vAxisTextPosition = settings['vaxis_text_position'];
		var vAxisDirection = (settings['vaxis_direction'] == 'checked') ? -1 : 1;
		var hAxisDirection = (settings['haxis_direction'] == 'checked') ? -1 : 1;
		var hAxisTextColor = settings['haxis_text_color'];
		var vAxisTextColor = settings['vaxis_text_color'];
		var hAxisSlantedText = settings['haxis_slanted'];
		var hAxisSlantedTextAngle = settings['haxis_slanted_text_angle'];
		var opacity = settings['opacity'];
		var lineWidth = settings['line_width'];

		var enableAnimation = (settings['enable_animation'] == 'checked') ? true : false;
		var animationDuration = settings['animation_duration'];

		/* == Google part == */
		google.charts.load('current', {'packages':['corechart']});
		google.charts.setOnLoadCallback(drawChart);

		function drawChart() {
			_this.chartData = google.visualization.arrayToDataTable(dataTypes);

			_this.chartOptions = {
				backgroundColor: 'transparent',
				fontSize: chartFontSize,
				legend: {
					position: legendPosition,
					alignment: legendAlignment,
					textStyle: {
						color: legendColor
					}
				},
				tooltip: { 
					trigger: tooltipTrigger,
					showColorCode: showColorCode,
					textStyle: {
						color: tooltipTextColor
					}
				},
				hAxis: {
					title: hAxisTitle,
					textPosition: hAxisTextPosition,
					direction: hAxisDirection,
					textStyle: {
						color: hAxisTextColor
					},
					slantedText: hAxisSlantedText,
					slantedTextAngle: hAxisSlantedTextAngle
				},
				vAxis: {
					title: vAxisTitle,
					textPosition: vAxisTextPosition,
					direction: vAxisDirection,
					textStyle: {
						color: vAxisTextColor
					}
				},
				focusTarget: focusTarget,
				dataOpacity: opacity,
				lineWidth: lineWidth,
				animation: {
					startup: enableAnimation,
					duration: animationDuration,
        			easing: 'linear',
				}
			};

			_this.chartObj = new google.visualization.LineChart(document.getElementById(_this.htmlClassPrefix + chartType));

			_this.chartObj.draw( _this.chartData, _this.chartOptions );
			_this.resizeChart();
		}
		/* */
	}

	// Detect window resize moment to draw charts responsively 
	AysChartBuilder.prototype.resizeChart = function(){
		var _this = this;

		//create trigger to resizeEnd event     
		$(window).resize(function() {
			if(this.resizeTO) clearTimeout(this.resizeTO);
			this.resizeTO = setTimeout(function() {
				$(this).trigger('resizeEnd');
			}, 100);
		});
	
		//redraw graph when window resize is completed  
		$(window).on('resizeEnd', function() {
			_this.chartObj.draw( _this.chartData, _this.chartOptions );
		});
		
	}

	// Load chart by pie chart
	AysChartBuilder.prototype.chartConvertData = function( data ){
		var _this = this;
		var dataTypes = [];

		// Collect data in new array for chart rendering
		for ( var key in data ) {
			if ( data.hasOwnProperty( key ) ) {
				if (key == 0) {
					if (data[key][0] != '' && data[key][1] != '') {
						dataTypes.push([
							_this.htmlDecode(data[key][0]), _this.htmlDecode(data[key][1])
						]);
					}
				} else {
					if (data[key][0] != '' && data[key][1] != '') {
						dataTypes.push([
							_this.htmlDecode(data[key][0]), +(data[key][1])
						]);
					}
				}
			}
		}

		return dataTypes;
	}

	// Converting chart data for multicolumn chart
	AysChartBuilder.prototype.multiColumnChartConvertData = function( data ){
		var _this = this;
		var dataTypes = [];
		var titleRow = [];

		for (var key in data) {
			var dataRow = [];
			if (data.hasOwnProperty(key)) {
				if (key == 0) {
					for (var index in data[key]) {
						if (data[key][index] != '') {
							titleRow.push(_this.htmlDecode(data[key][index]));
						}
					}
					dataTypes.push(titleRow);
				} else {
					for (var index in data[key]) {
						if (data[key][index] != '') {
							if  (index == 0) {
								dataRow.push(_this.htmlDecode(data[key][index]));
							} else {
								dataRow.push(+data[key][index]);
							}
						}
					}
					dataTypes.push(dataRow);
				}
			}
		}

		return dataTypes;
	}

	// Update chart data and display immediately
	AysChartBuilder.prototype.updateChartData =  function( newData ){
		var _this = this;
		_this.chartObj.draw( newData, _this.chartOptions );
	}

	AysChartBuilder.prototype.addChartDataRow = function (element){
        // var deleteImageUrl = ChartBuilderSourceData.removeManualDataRow;
        var content = '';

        var addedTermsandConds = this.$el.find("."+this.htmlClassPrefix+"chart-source-data-edit-block");
        var addedTermsandCondsId = this.$el.find("."+this.htmlClassPrefix+"chart-source-data-edit-block:last-child");
        var dataId = addedTermsandConds.length >= 1 ? addedTermsandCondsId.data("sourceId") + 1 : 1;
		var colCount = addedTermsandConds.first().children().length - 1;

        var termsCondsMessageAttrName = this.newTermsCondsMessageAttrName(  this.htmlNamePrefix + 'chart_source_data' ,  dataId );

		content += '<div class = "'+this.htmlClassPrefix+'chart-source-data-edit-block" data-source-id="' + dataId + '" >';
			content += '<div class="'+this.htmlClassPrefix+'icons-box '+this.htmlClassPrefix+'icons-remove-box">';
				content += '<svg class="'+this.htmlClassPrefix+'chart-source-data-remove-block '+this.htmlClassPrefix+'chart-source-data-remove-row" data-trigger="hover" data-bs-toggle="tooltip" title="Delete row" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path d="M310.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L160 210.7 54.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L114.7 256 9.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L160 301.3 265.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L205.3 256 310.6 150.6z" style="fill: #b8b8b8;"/></svg>';
			content += '</div>';
			for (var i = 0; i < colCount; i++) {
				if (i == 0) {
					content += '<div class="'+this.htmlClassPrefix+'chart-source-data-input-box '+this.htmlClassPrefix+'chart-source-data-name-input-box">';
						content += '<input type="text" class="ays-text-input form-control" name="' + termsCondsMessageAttrName + '">';
					content += '</div>';
				} else {
					content += '<div class="'+this.htmlClassPrefix+'chart-source-data-input-box '+this.htmlClassPrefix+'chart-source-data-input-number">';
						content += '<input type="number" class="ays-text-input form-control" name="' + termsCondsMessageAttrName + '">';
					content += '</div>';
				}
			}
		content += '</div>';

		this.$el.find('.'+this.htmlClassPrefix+'chart-source-data-content').append(content);
		$('[data-bs-toggle="tooltip"]').tooltip();
	}

	AysChartBuilder.prototype.addChartDataColumn = function (e){
		var _this = this;

		var rows = this.$el.find("."+this.htmlClassPrefix+"chart-source-data-content").children();
		rows.each(function(key, row){
			var dataIDEach = row.getAttribute('data-source-id');
			var content = '';

			if (key === 0) {
				content += '<div class="'+_this.htmlClassPrefix+'chart-source-data-input-box ' +_this.htmlClassPrefix+'chart-source-title-box">';
					content += '<svg class="'+_this.htmlClassPrefix+'chart-source-data-remove-block '+_this.htmlClassPrefix+'chart-source-data-remove-col" data-trigger="hover" data-bs-toggle="tooltip" title="Delete column" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512" width="10px">';
						content += '<path d="M310.6 150.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L160 210.7 54.6 105.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L114.7 256 9.4 361.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L160 301.3 265.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L205.3 256 310.6 150.6z" style="fill: #b8b8b8;"/>';
					content += '</svg>';
					content += '<input type="text" class="ays-text-input form-control ' + _this.htmlClassPrefix+'chart-source-title-input" name="' + _this.newTermsCondsMessageAttrName(  _this.htmlNamePrefix + 'chart_source_data' ,  dataIDEach ) + '">';
				content += '</div>';
			} else {
				content += '<div class="'+_this.htmlClassPrefix+'chart-source-data-input-box ' +_this.htmlClassPrefix+'chart-source-data-input-number">';
					content += '<input type="number" class="ays-text-input form-control" name="' + _this.newTermsCondsMessageAttrName(  _this.htmlNamePrefix + 'chart_source_data' ,  dataIDEach ) + '">';
				content += '</div>';
			}

			$(row).append(content);
			$('[data-bs-toggle="tooltip"]').tooltip();
		});
	}

	AysChartBuilder.prototype.deleteChartDataRow = function (element){
		var _this = this;

		var rows = _this.$el.find("."+_this.htmlClassPrefix+"chart-source-data-content").children();
		if ((rows.length - 1) >= 2) {
			var confirm = window.confirm(aysChartBuilderAdmin.confirmRowDelete);
			if (confirm) {
				var thisMainParent = element.parent().parent();
				thisMainParent.remove();
			}
		} else {
			alert(aysChartBuilderAdmin.minRowNotice);
		}

		element.blur();
		element.tooltip('hide');
	}

	AysChartBuilder.prototype.deleteChartDataColumn = function (element){
		var _this = this;

		var rows = _this.$el.find("."+_this.htmlClassPrefix+"chart-source-data-content").children();
		if (rows.eq(1).children('.ays-chart-chart-source-data-input-number').length >= 2) {
			var confirm = window.confirm(aysChartBuilderAdmin.confirmColDelete);
			if (confirm) {
				var parent = element.parents('.ays-chart-chart-source-title-box');
				var index = _this.returnIndexOfEl(parent);
				rows.each(function(key, row){
					var dataRow = $(row).find('.ays-chart-chart-source-data-input-box:not("ays-chart-chart-source-data-name-input-box")');
					$(dataRow).each(function(ind, cell){
						if (ind == index) {
							$(cell).remove();
						}
					});
				});
			}
		} else {
			alert(aysChartBuilderAdmin.minColNotice);
		}

		element.blur();
		element.tooltip('hide');
	}
	
	AysChartBuilder.prototype.returnIndexOfEl = function (element){
		var i = 0;
		var elements = element.parent().find('.ays-chart-chart-source-title-box');
		elements.each(function(key, cell){
			if ($(cell).is(element)) {
				i = key;
			}
		});
		return i;
	}

	AysChartBuilder.prototype.configureOptions = function( chartType ) {
		$(document).find('.ays-chart-chart-source-title-box').eq(0).find('.ays-chart-chart-source-data-remove-block').css('visibility', 'hidden');
		var haxisTab = $(document).find('.ays-chart-options-haxis-settings-tab').parents('fieldset.ays-accordion-options-container');
		var vaxisTab = $(document).find('.ays-chart-options-vaxis-settings-tab').parents('fieldset.ays-accordion-options-container');
		var animationTab = $(document).find('.ays-chart-options-animation-settings-tab').parents('fieldset.ays-accordion-options-container');
		var addColButton = $(document).find('.ays-chart-add-new-column-box');
		var legendOption = $(document).find('#ays-chart-option-legend-position option');
		// var pieSettings = $(document).find('.ays-chart-options-pie-section');
		// var barSettings = $(document).find('.ays-chart-options-bar-section');
		// var columnSettings = $(document).find('.ays-chart-options-column-section');
		// var lineSettings = $(document).find('.ays-chart-options-line-section');
		var pieRotationDegree = $(document).find('#ays-chart-option-rotation-degree').parents('.ays-chart-options-section');
		var pieSliceBorderColor = $(document).find('#ays-chart-option-slice-border-color').parents('.ays-chart-options-section');
		var focusTarget = $(document).find('#ays-chart-option-focus-target').parents('.ays-chart-options-section');
		var tooltipText = $(document).find('#ays-chart-option-tooltip-text').parents('.ays-chart-options-section');
		var isStacked = $(document).find('#ays-chart-option-is-stacked').parents('.ays-chart-options-section');
		var lineCurveType = $(document).find('#ays-chart-option-line-curve-type').parents('.ays-chart-options-section');
		var lineWidth = $(document).find('#ays-chart-option-line-width').parents('.ays-chart-options-section');
		var reverseCategories = $(document).find('#ays-chart-option-reverse-categories').parents('.ays-chart-options-section');
		var sliceText = $(document).find('#ays-chart-option-slice-text').parents('.ays-chart-options-section');
		var opacity = $(document).find('#ays-chart-option-opacity').parents('.ays-chart-options-section');
		
		switch (chartType) {
			case 'pie_chart':
				// pieSettings.show();
				pieRotationDegree.show();
				pieSliceBorderColor.show();
				focusTarget.hide();
				isStacked.hide();
				reverseCategories.show();
				tooltipText.show();
				sliceText.show();
				opacity.hide();
				haxisTab.remove();
				vaxisTab.remove();
				animationTab.remove();
				legendOption.eq(4).remove();
				break;
			case 'bar_chart':
				// barSettings.show();
				legendOption.eq(0).remove();
				legendOption.eq(5).remove();
				addColButton.show();
				break;
			case 'column_chart':
				// columnSettings.show();
				legendOption.eq(0).remove();
				legendOption.eq(5).remove();
				addColButton.show();
				break;
			case 'line_chart':
				// lineSettings.show();
				legendOption.eq(0).remove();
				legendOption.eq(5).remove();
				addColButton.show();
				isStacked.hide();
				lineCurveType.show();
				lineWidth.show();
				break;
			default:
				break;
		}
	}

	AysChartBuilder.prototype.newTermsCondsMessageAttrName = function (termCondName, termCondId){
		var _this = this;
		return termCondName + '['+ termCondId +'][]';	
	}
    
    AysChartBuilder.prototype.setAccordionEvents = function(e){
        var _this = this;
        _this.$el.on('click', '.ays-accordion-options-header', function(e){
			_this.openCloseAccordion(e, _this);
		});
    }
    
    AysChartBuilder.prototype.openCloseAccordion = function(e, _this){

        var container = $(e.target).parents('.ays-accordion-options-container');

        if( container.attr('data-collapsed') === 'true' ){
			_this.closeAllAccordions( container.parents('.ays-tab-content').attr('id') );
            container.find('.ays-accordion-options-content').slideDown(300, function () {
				container.attr('data-collapsed', 'false');
			});
			container.find('.ays-accordion-options-header .ays-accordion-arrow').removeClass('ays-accordion-arrow-right').addClass('ays-accordion-arrow-down');
        }else{
			container.find('.ays-accordion-options-content').slideUp(300, function () {
				container.attr('data-collapsed', 'true');
			});
			container.find('.ays-accordion-options-header .ays-accordion-arrow').removeClass('ays-accordion-arrow-down').addClass('ays-accordion-arrow-right');
        }
    }
    
    AysChartBuilder.prototype.closeAllAccordions = function( tab ){
		var _this = this;
        var container = _this.$el.find('#' + tab + ' .ays-accordions-container').eq(0);
		container.find('.ays-accordion-options-container').each(function (){
			var $this = $(this);
			container.find('.ays-accordion-options-content').slideUp(300, function () {
				$this.attr('data-collapsed', 'true');
			});
			$(this).find('.ays-accordion-options-header .ays-accordion-arrow').removeClass('ays-accordion-arrow-down').addClass('ays-accordion-arrow-right');
		});
    }

	AysChartBuilder.prototype.initDbImportComponent = function(){
		var _this = this;
		var table_columns = window.aysChartBuilderChartSettings.db_query.tables;
		var code_mirror = wp.CodeMirror || CodeMirror;
		var cm = code_mirror.fromTextArea(_this.$el.find('.ays-chart-db-query').get(0), {
			value: _this.$el.find('.ays-chart-db-query').val(),
			autofocus: false,
			mode: 'text/x-mysql',
			lineWrapping: true,
			dragDrop: false,
			matchBrackets: true,
			autoCloseBrackets: true,
			extraKeys: {"Ctrl-Space": "autocomplete"},
			hintOptions: { tables: table_columns }
		});

		// force refresh so that the query shows on first time load. Otherwise you have to click on the editor for it to show.
		_this.$el.on('ays-chart:db:query:focus', function(event, data){
			cm.refresh();
		});

		// cm.focus();

		// update text area.
		cm.on('inputRead', function(x, y){
			cm.save();
		});

		// backspace and delete do not register so the text box does not get empty if the entire query is deleted
		// from the editor. Let's force this.
		_this.$el.on('ays-chart:db:query:update', function(event, data){
			cm.save();
		});

		// clear the editor.
		_this.$el.on('ays-chart:db:query:setvalue', function(event, data){
			cm.setValue(data.value);
			cm.clearHistory();
			cm.refresh();
		});

		// set an option at runtime?
		_this.$el.on('ays-chart:db:query:changeoption', function(event, data){
			cm.setOption(data.name, data.value);
		});
	}

	AysChartBuilder.prototype.initDbImport = function(){
		var _this = this;
		var chartType = _this.$el.find('#ays-chart-option-chart-type').val();

		_this.initDbImportComponent();
	}

	AysChartBuilder.prototype.initQuizDBImport = function(){
		var _this = this;
		var chartType = _this.$el.find('#ays-chart-option-chart-type').val();

		_this.$el.find('#ays-chart-quiz-maker-fetch').on('click', function(e){
			var select_query = $(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-data-query').val();
			if (select_query == "") {
				return;
			}
			
			_this.fetchQuizData( true );
		});

		_this.$el.find('#ays-chart-quiz-maker-show-on-chart').on( 'click', function(){
			var select_query = $(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-data-query').val();
			if (select_query == "") {
				return;
			}

			if( _this.chartTempData ){
				_this.$el.find('#ays-chart-quiz-maker-success').empty();
				_this.$el.find('#ays-chart-quiz-maker-error').empty();
				if (chartType == 'line_chart' || chartType == 'bar_chart' || chartType == 'column_chart') {
					_this.chartTempData = _this.multiColumnChartConvertData( _this.chartTempData );
				} else if (chartType == 'org_chart') {
					_this.chartTempData = _this.orgChartConvertData( _this.chartTempData );
				} else {
					_this.chartTempData = _this.chartConvertData( _this.chartTempData );
				}
				_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData );

				_this.updateChartData( _this.chartData );

				_this.chartTempData = null;
			}else{
				_this.fetchQuizData( false, true );
			}

		});

		_this.$el.find('#ays-chart-quiz-maker-save').on( 'click', function(){
			var select_query = $(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-data-query').val();
			if (select_query == "") {
				return;
			}

			_this.$el.find('#ays-chart-quiz-maker-success').empty();
			_this.$el.find('#ays-chart-quiz-maker-error').empty();

			var chart_id = $(document).find('.' + _this.htmlClassPrefix + 'chart-id').val();
			var query = $(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-data-query').find('option:selected').val();
			var selectQuizSelectDisplay = $(document).find('.'+_this.htmlClassPrefix+'select-quiz-maker-quiz-container').css('display');
			var quizID = null;
			if (selectQuizSelectDisplay != 'none') {
				quizID = $(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-quiz').find('option:selected').val();
				if (quizID == 0) {
					_this.$el.find('#ays-chart-quiz-maker-error').html( 'Please select a quiz.' );
					return;
				}
			}

			// submit only if a query has been provided.
			if( query.length > 0 ){
				_this.startAjax( _this.$el.find('#ays-chart-quiz-maker-form') );

				$.ajax({
					url: ajaxurl,
					method: 'post',
					dataType: 'json',
					data: {
						'action': _this.ajaxAction,
						'function': window.aysChartBuilderChartSettings.ajax['actions']['quiz_maker_save_data'],
						'security': window.aysChartBuilderChartSettings.ajax['nonces']['quiz_maker_save_data'],
						'params': {
							query: query,
							quizID: quizID,
							chart_id: chart_id,
						}
					},
					success: function( response ){
						if( response.success ){
							_this.$el.find('#ays-chart-quiz-maker-success').html( response.data.msg );
							_this.$el.find('input[name="' + _this.htmlNamePrefix + 'source_type"]').val('quiz_maker');
						}else{
							_this.$el.find('#ays-chart-quiz-maker-error').html( response.data.msg );
							_this.$el.find('input[name="' + _this.htmlNamePrefix + 'source_type"]').val('manual');
						}
					},
					complete: function(){
						_this.endAjax( _this.$el.find('#ays-chart-quiz-maker-form') );
					}
				});
			}else{
				_this.$el.find('#ays-chart-quiz-maker-form').unlock();
				_this.$el.find('input[name="' + _this.htmlNamePrefix + 'source_type"]').val('manual');
			}
		});

		$(document).on('ays-chart:modal:close', function (){
			_this.chartTempData = null;
		});
	}

	AysChartBuilder.prototype.fetchQuizData = function( openModal = false, showOnChart = false ){
		var _this = this;
		var chartType = _this.$el.find('#ays-chart-option-chart-type').val();
		_this.$el.trigger('ays-chart:db:query:update', {});

		var chart_id = $(document).find('.' + _this.htmlClassPrefix + 'chart-id').val();
		var query = $(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-data-query').find('option:selected').val();
		var selectQuizSelectDisplay = $(document).find('.'+_this.htmlClassPrefix+'select-quiz-maker-quiz-container').css('display');
		var quizID = null;
		if (selectQuizSelectDisplay != 'none') {
			quizID = $(document).find('#'+_this.htmlClassPrefix+'select-quiz-maker-quiz').find('option:selected').val();
			if (quizID == 0) {
				_this.$el.find('#ays-chart-quiz-maker-error').html( 'Please select a quiz.' );
				return;
			}
		}

		if (query.length == 0) {
			return;
		}

		_this.startAjax( _this.$el.find('#ays-chart-quiz-maker-form') );

		var modal = $(document).find('#ays-chart-db-query-results');

		_this.$el.find('.db-wizard-results').empty();
		_this.$el.find('#ays-chart-quiz-maker-success').empty();
		_this.$el.find('#ays-chart-quiz-maker-error').empty();

		$.ajax({
			url: ajaxurl,
			method: 'post',
			dataType: 'json',
			data: {
				'action': _this.ajaxAction,
				'function': window.aysChartBuilderChartSettings.ajax['actions']['quiz_maker_get_data'],
				'security': window.aysChartBuilderChartSettings.ajax['nonces']['quiz_maker_get_data'],
				'params': {
					query: query,
					quizID: quizID,
					chart_id: chart_id,
				}
			},
			success: function( response ){
				if( response.success ){
					modal.find('.db-wizard-results').html( response.data.table );
					modal.find('#results').DataTable({
						"paging": true
					});
					modal.find('#results').parent().addClass('ays-db-results-wrap');
					
					if( openModal === true ) {
						modal.aysModal('show');
					}

					_this.chartTempData = response.data.data ? response.data.data : null;

					if( showOnChart === true ) {
						if (chartType == 'line_chart' || chartType == 'bar_chart' || chartType == 'column_chart') {
							_this.chartTempData = _this.multiColumnChartConvertData( _this.chartTempData );
						} else if (chartType == 'org_chart') {
							_this.chartTempData = _this.orgChartConvertData( _this.chartTempData );
						} else {
							_this.chartTempData = _this.chartConvertData( _this.chartTempData );
						}
						_this.chartData = window.google.visualization.arrayToDataTable(_this.chartTempData);

						_this.updateChartData(_this.chartData);

						_this.chartTempData = null;
					}
				}else{
					modal.find('ays-close').trigger('click');
					_this.$el.find('#ays-chart-quiz-maker-error').html( response.data.msg );
					_this.$el.find('input[name="' + _this.htmlNamePrefix + 'source_type"]').val('manual');
				}
			},
			complete: function(){
				_this.endAjax( _this.$el.find('#ays-chart-quiz-maker-form') );
			}
		});
	}

	AysChartBuilder.prototype.startAjax = function( element ){
		element.lock();
	}

	AysChartBuilder.prototype.endAjax = function( element ){
		element.unlock();
	}

	AysChartBuilder.prototype.quickSaveHotKeys = function() {
		$(document).on('keydown', function(e){
			var saveButton = $(document).find('input#ays-button-apply');
			if ( saveButton.length > 0 ) {
                if (!(e.which == 83 && e.ctrlKey) && !(e.which == 19)){
                    return true;
                }
                saveButton.trigger("click");
                e.preventDefault();
                return false;
            }
		});
	}

	// Manual data show on chart button
	AysChartBuilder.prototype.showOnChart = function (button, chartType) {
		var _this = this;
		
		var lastId = $(document).find(".ays-chart-chart-source-data-edit-block:last-child").attr('data-source-id');
		var chartData = [];

		var rowTitles = $(document).find('.ays-chart-chart-source-data-name-input-box');
		rowTitles.each(function(key, el) {
			var value = $(el).find('input').val();
			if ( value == '' ) {
				$(el).find('input').val('Option');
			}
		});

		var form = $(document).find("#ays-charts-form");
		var data = form.serializeFormJSON();

		for (var i = 0; i <= lastId; i++) {
			if (data['ays_chart_source_data['+i+'][]'] !== undefined) {
				var dataRow = data['ays_chart_source_data['+i+'][]'];
				var filteredRow = [];
				for (var key = 0; key < dataRow.length; key++) {
					var value = dataRow[key];
					if (value != '') {
						filteredRow.push(value);
					} else {
						if (i == 0) {
							filteredRow.push('Title'+key);
						} else {
							filteredRow.push('0');
						}
					}
				}
				if (filteredRow.length != 0) {
					chartData.push(filteredRow);
				}
			}
		}
		if (chartType == 'line_chart' || chartType == 'bar_chart' || chartType == 'column_chart') {
			_this.chartTempData = _this.multiColumnChartConvertData( chartData );
		} else {
			_this.chartTempData = _this.chartConvertData( chartData );
		}

		_this.chartData = window.google.visualization.arrayToDataTable( _this.chartTempData );

		_this.updateChartData( _this.chartData );

		_this.chartTempData = null;
	}

	AysChartBuilder.prototype.htmlDecode = function (input) {
		var e = document.createElement('div');
		e.innerHTML = input;
		return e.childNodes[0].nodeValue;
	}

	$.fn.AysChartBuilderMain = function(options) {
        return this.each(function() {
            if (!$.data(this, 'AysChartBuilderMain')) {
                $.data(this, 'AysChartBuilderMain', new AysChartBuilder(this, options));
            } else {
                try {
                    $(this).data('AysChartBuilderMain').init();
                } catch (err) {
                    console.error('AysChartBuilderMain has not initiated properly');
                }
            }
        });
    };
    $(document).find('#ays-charts-form').AysChartBuilderMain();

})(jQuery);

(function ($) {

	$.fn.serializeFormJSON = function () {
		let o = {},
			a = this.serializeArray();
		$.each(a, function () {
			if (o[this.name]) {
				if (!o[this.name].push) {
					o[this.name] = [o[this.name]];
				}
				o[this.name].push(this.value || '');
			} else {
				o[this.name] = this.value || '';
			}
		});
		return o;
	};

	$.fn.lock = function () {
		$(this).each(function () {
			var $this = $(this);
			var position = $this.css('position');

			if (!position) {
				position = 'static';
			}

			switch (position) {
				case 'absolute':
				case 'relative':
					break;
				default:
					$this.css('position', 'relative');
					break;
			}
			$this.data('position', position);

			var width = $this.width(),
				height = $this.height();

			var locker = $('<div class="locker"></div>');
			locker.width(width).height(height);

			var loader = $('<div class="locker-loader"></div>');
			loader.width(width).height(height);

			locker.append(loader);
			$this.append(locker);
			$(window).resize(function () {
				$this.find('.locker,.locker-loader').width($this.width()).height($this.height());
			});
		});

		return $(this);
	};

	$.fn.unlock = function () {
		$(this).each(function () {
			$(this).find('.locker').remove();
			$(this).css('position', $(this).data('position'));
		});

		return $(this);
	};
})(jQuery);