(function($) {
    'use strict';

	$(document).ready(function () {

		$('[data-toggle="popover"]').popover();
    	$('[data-bs-toggle="tooltip"]').tooltip();
		
		$(document).find('#ays-title').on('input', function () {
            $(document).find('.ays_chart_title_in_top').text($(this).val());
        });
		
    	$(document).find('.form-check-input.select-all').on('click', function() {
			var checkboxes = $(document).find('.check-current-row');
			if ($(this).prop('checked') == true && checkboxes.length !== 0) {
				$(this).parents('thead').next('tbody').find('tr').addClass("ays-chart-tr-selected");
				checkboxes.prop('checked',true);
				$(document).find('#ays-chart-bulk-delete').prop('disabled', false);
			} else {
				$(this).parents('thead').next('tbody').find('tr').removeClass("ays-chart-tr-selected");
				checkboxes.prop('checked',false);
				$(document).find('#ays-chart-bulk-delete').prop('disabled', true);
			}
		});

		$(document).find('.check-current-row').on('click', function() {
			var checkboxesArr = $(document).find('.check-current-row');
			var selectAllCheckBox = $(document).find('.form-check-input.select-all'); 
			var count = 0;

			for (var i = 0; i < checkboxesArr.length; i++) {
				if (checkboxesArr.eq(i).prop('checked') == true) {
					count++;
				}
			}	

			if ((count == 0 && selectAllCheckBox.prop('checked') == true) || (count != 0 && selectAllCheckBox.prop('checked') == true)) {
				selectAllCheckBox.prop('checked', false);	
			} else if (count == checkboxesArr.length && selectAllCheckBox.prop('checked') == false) {
				selectAllCheckBox.prop('checked', true);
			}

			if ( $(this).prop('checked') ) {
				$(this).parents('tr').addClass("ays-chart-tr-selected");
				$(document).find('#ays-chart-bulk-delete').prop('disabled', false);
			} else if ( !$(this).prop('checked') && count > 0) {
				$(this).parents('tr').removeClass("ays-chart-tr-selected");
				$(document).find('#ays-chart-bulk-delete').prop('disabled', false);
			} else {
				$(this).parents('tr').removeClass("ays-chart-tr-selected");
				$(document).find('#ays-chart-bulk-delete').prop('disabled', true);
			}
		});

		$(document).on('click', '#ays-chart-bulk-delete', function(e) {
			e.preventDefault();
			var confirm = window.confirm(aysChartBuilderAdmin.confirmDelete);
			if (confirm) {
				$(document).find('#ays-chart-bulk-delete-confirm').trigger('click');
			}
		});

		// Delete confirmation
		$(document).on('click', '.ays_chart_delete_confirm', function(e){            
			e.preventDefault();
			var confirm = window.confirm(aysChartBuilderAdmin.confirmDelete);
			if (confirm){
				window.location.replace($(this).attr('href'));
			}
		});

		$(document).find("input#ays-chart-search-input + button#ays-chart-search").on("click", function (e) {
			var _this  = $(this);
            var parent = _this.parents('form');
            
            var search_input = parent.find('input#ays-chart-search-input');
            var input_value  = search_input.val();
			
            var field = 's';
            var flag = false;
            var url = window.location.href;
            if (url.indexOf('?' + field + '=') != -1) {
				flag = true;
            } else if (url.indexOf('&' + field + '=') != -1) {
				flag = true;
            }
			
			// location.href = location.href.replace(/&paged=([^&]$|[^&]*)/i, "&paged=1");
            if (flag) {
				if (typeof input_value != 'undefined' && input_value != "") {
					url = location.href.replace(/&s=([^&]$|[^&]*)/i, "&s="+input_value);
				} else if (input_value == "") {
					url = location.href.replace(/&s=([^&]$|[^&]*)/i, "");
				}
            } else {
				if (typeof input_value != 'undefined' && input_value != "") {
					url = location.href + "&s=" + input_value;
				}
			}

			e.preventDefault();
			location.href = url.replace(/&paged=([^&]$|[^&]*)/i, "&paged=1");
        });

		$(document).find("button#ays-chart-filter").on("click", function (e) {
			var _this  = $(this);
            var parent = _this.parents('form');
            
            var search_input = parent.find('select#ays-chart-filter-select');
            var input_value  = search_input.val();
			var search_input2 = parent.find('select#ays-chart-filter-author');
            var input_value2  = search_input2.val();
			
            var field = 'filterbytype';
            var flag = false;
			var field2 = 'filterbyauthor';
            var flag2 = false;
            var url = window.location.href;
            if (url.indexOf('?' + field + '=') != -1) {
				flag = true;
            } else if (url.indexOf('&' + field + '=') != -1) {
				flag = true;
            }
			if (url.indexOf('?' + field2 + '=') != -1) {
				flag2 = true;
            } else if (url.indexOf('&' + field2 + '=') != -1) {
				flag2 = true;
            }
			
            if (flag) {
				if (typeof input_value != 'undefined' && input_value != "") {
					url = url.replace(/&filterbytype=([^&]$|[^&]*)/i, "&filterbytype="+input_value);
				} else if (input_value == "") {
					url = url.replace(/&filterbytype=([^&]$|[^&]*)/i, "");
				}
            } else {
				if (typeof input_value != 'undefined' && input_value != "") {
					url = url + "&filterbytype=" + input_value;
				}
			}

			if (flag2) {
				if (typeof input_value2 != 'undefined' && input_value2 != "") {
					url = url.replace(/&filterbyauthor=([^&]$|[^&]*)/i, "&filterbyauthor="+input_value2);
				} else if (input_value2 == "") {
					url = url.replace(/&filterbyauthor=([^&]$|[^&]*)/i, "");
				}
            } else {
				if (typeof input_value2 != 'undefined' && input_value2 != "") {
					url = url + "&filterbyauthor=" + input_value2;
				}
			}

			e.preventDefault();
			location.href = url.replace(/&paged=([^&]$|[^&]*)/i, "&paged=1");
        });

		$(document).find("button#ays-chart-filter-clear").on("click", function (e) {
			var _this  = $(this);
            
            var url = window.location.href;
			var field = 'filterbytype';
			var flag = false;
			var field2 = 'filterbyauthor';
			var flag2 = false;

            if (url.indexOf('?' + field + '=') != -1) {
				flag = true;
            } else if (url.indexOf('&' + field + '=') != -1) {
				flag = true;
            }
			if (url.indexOf('?' + field2 + '=') != -1) {
				flag2 = true;
            } else if (url.indexOf('&' + field2 + '=') != -1) {
				flag2 = true;
            }

			if (flag) {
				url = url.replace(/&filterbytype=([^&]$|[^&]*)/i, "");
			}
			if (flag2) {
				url = url.replace(/&filterbyauthor=([^&]$|[^&]*)/i, "");
			}

			e.preventDefault();
			location.href = url.replace(/&paged=([^&]$|[^&]*)/i, "&paged=1");
        });

		$(document).find('#ays-chart-filter-author').select2({
			placeholder: aysChartBuilderAdmin.selectUser,
			minimumInputLength: 1,
			allowClear: true,
			language: {
				searching: function() {
					return aysChartBuilderAdmin.searching;
				},
				inputTooShort: function () {
					return aysChartBuilderAdmin.pleaseEnterMore;
				}
			},
			ajax: {
				url: ajaxurl,
				dataType: 'json',
				data: function (response) {
					var checkedUsers = $(document).find('#ays-chart-filter-author').val();
					return {
						action: 'ays_chart_admin_ajax',
						function: window.aysChartBuilderChartSettings.ajax['actions']['author_user_search'],
						security: window.aysChartBuilderChartSettings.ajax['nonces']['author_user_search'],
						params: {
							search: response.term,
							val: checkedUsers
						}
					};
				}
			}
		});

		$(document).on('mouseenter', 'td.column-title', function() {
			// $(this).find('.chart-list-table-actions-row').css('visibility', 'visible');
			$(this).find('.chart-list-table-actions-row').css('display', 'flex');
			$(this).css('padding', '8px 8px');
		});
		$(document).on('mouseleave', 'td.column-title', function() {
			// $(this).find('.chart-list-table-actions-row').css('visibility', 'hidden');
			$(this).find('.chart-list-table-actions-row').hide();
			$(this).css('padding', '23px 8px');

		});

		$(document).find('.ays-chart-copy-image').on('click', function(){
			var _this = this;
			var input = $(_this).parent().find('input.ays-chart-shortcode-input');
			var length = input.val().length;

			input[0].focus();
			input[0].setSelectionRange(0, length);
			document.execCommand('copy');
			// document.getSelection().removeAllRanges();

			$(_this).attr('data-original-title', aysChartBuilderAdmin.copied);
			$(_this).attr("data-bs-original-title", aysChartBuilderAdmin.copied);
			$(_this).attr("title", aysChartBuilderAdmin.copied);
			$(_this).tooltip('show');
		});

		$(document).find('.ays-chart-copy-image').on('mouseleave', function(){
			var _this = this;

			$(_this).attr('data-original-title', aysChartBuilderAdmin.clickForCopy);
			$(_this).attr("data-bs-original-title", aysChartBuilderAdmin.clickForCopy);
			$(_this).attr("title", aysChartBuilderAdmin.clickForCopy);
		});

		$(document).on('click', '.notice-dismiss', function (e) {
			changeCurrentUrl('status');
		});

		var toggle_ddmenu = $(document).find('.toggle_ddmenu');
    	toggle_ddmenu.on('click', function () {
    	    var ddmenu = $(this).next();
    	    var state = ddmenu.attr('data-expanded');
    	    switch (state) {
    	        case 'true':
    	            $(this).find('.ays_fa').css({
    	                transform: 'rotate(0deg)'
    	            });
    	            ddmenu.attr('data-expanded', 'false');
    	            break;
    	        case 'false':
    	            $(this).find('.ays_fa').css({
    	                transform: 'rotate(90deg)'
    	            });
    	            ddmenu.attr('data-expanded', 'true');
    	            break;
    	    }
    	});

		function changeCurrentUrl(key){
			var linkModified = location.href.split('?')[1].split('&');
			for(var i = 0; i < linkModified.length; i++){
				if(linkModified[i].split("=")[0] == key){
					linkModified.splice(i, 1);
				}
			}
			linkModified = linkModified.join('&');
			window.history.replaceState({}, document.title, '?'+linkModified);
		}

		var checkCountdownIsExists = $(document).find('#ays-chart-builder-countdown-main-container');
        // if ( checkCountdownIsExists.length > 0 ) {
        //     var second  = 1000,
        //         minute  = second * 60,
        //         hour    = minute * 60,
        //         day     = hour * 24;

        //     var countdownEndTime = "FEB 28, 2023 23:59:59",
        //     countDown = new Date(countdownEndTime).getTime(),
        //     x = setInterval(function() {

        //         var now = new Date().getTime(),
        //             distance = countDown - now;

        //         var countDownDays    = document.getElementById("ays-chart-countdown-days");
        //         var countDownHours   = document.getElementById("ays-chart-countdown-hours");
        //         var countDownMinutes = document.getElementById("ays-chart-countdown-minutes");
        //         var countDownSeconds = document.getElementById("ays-chart-countdown-seconds");

        //         if(countDownDays !== null || countDownHours !== null || countDownMinutes !== null || countDownSeconds !== null){
        //             countDownDays.innerText = Math.floor(distance / (day)),
        //             countDownHours.innerText = Math.floor((distance % (day)) / (hour)),
        //             countDownMinutes.innerText = Math.floor((distance % (hour)) / (minute)),
        //             countDownSeconds.innerText = Math.floor((distance % (minute)) / second);
        //             // countDownDays.innerText     = Math.floor(distance / (day)).toLocaleString(undefined,{minimumIntegerDigits: 2})+" : ",
        //             // countDownHours.innerText    = Math.floor((distance % (day)) / (hour)).toLocaleString(undefined,{minimumIntegerDigits: 2})+" : ",
        //             // countDownMinutes.innerText  = Math.floor((distance % (hour)) / (minute)).toLocaleString(undefined,{minimumIntegerDigits: 2})+" : ",
        //             // countDownSeconds.innerText  = Math.floor((distance % (minute)) / second).toLocaleString(undefined,{minimumIntegerDigits: 2});

        //         }

        //         //do something later when date is reached
        //         if (distance < 0) {
        //             var headline  = document.getElementById("ays-chart-countdown-headline"),
        //                 countdown = document.getElementById("ays-chart-countdown"),
        //                 content   = document.getElementById("ays-chart-countdown-content");

        //           // headline.innerText = "Sale is over!";
        //           countdown.style.display = "none";
        //           content.style.display = "block";

        //           clearInterval(x);
        //         }
        //     }, 1000);
        // }

        if ( checkCountdownIsExists.length > 0 ) {
            var second  = 1000,
                minute  = second * 60,
                hour    = minute * 60,
                day     = hour * 24;

            var chartCountdownEndTime = aysChartBuilderAdmin.chartBannerDate;
            var countDown_new = new Date(chartCountdownEndTime).getTime();

            if ( isNaN(countDown_new) || isFinite(countDown_new) == false ) {
                var AYS_CHART_MILLISECONDS = 3 * day;
                var countdownStartDate = new Date(Date.now() + AYS_CHART_MILLISECONDS);
                var chartCountdownEndTime = countdownStartDate.aysChartCustomFormat( "#YYYY#-#MM#-#DD# #hhhh#:#mm#:#ss#" );
                var countDown_new = new Date(chartCountdownEndTime).getTime();
            }

            var y = setInterval(function() {

                var now = new Date().getTime();
                var distance_new = countDown_new - now;

                var countDownDays    = document.getElementById("ays-chart-countdown-days");
                var countDownHours   = document.getElementById("ays-chart-countdown-hours");
                var countDownMinutes = document.getElementById("ays-chart-countdown-minutes");
                var countDownSeconds = document.getElementById("ays-chart-countdown-seconds");

                if(countDownDays !== null || countDownHours !== null || countDownMinutes !== null || countDownSeconds !== null){

                    var countDownDays_innerText    = Math.floor(distance_new / (day));
                    var countDownHours_innerText   = Math.floor((distance_new % (day)) / (hour));
                    var countDownMinutes_innerText = Math.floor((distance_new % (hour)) / (minute));
                    var countDownSeconds_innerText = Math.floor((distance_new % (minute)) / second);

                    if( isNaN(countDownDays_innerText) || isNaN(countDownHours_innerText) || isNaN(countDownMinutes_innerText) || isNaN(countDownSeconds_innerText) ){
                        var headline  = document.getElementById("ays-chart-countdown-headline"),
                            countdown = document.getElementById("ays-chart-countdown"),
                            content   = document.getElementById("ays-chart-countdown-content");

                        // headline.innerText = "Sale is over!";
                        countdown.style.display = "none";
                        content.style.display = "block";

                        clearInterval(y);
                    } else {
                        countDownDays.innerText    = countDownDays_innerText;
                        countDownHours.innerText   = countDownHours_innerText;
                        countDownMinutes.innerText = countDownMinutes_innerText;
                        countDownSeconds.innerText = countDownSeconds_innerText;
                    }

                    // countDownDays.innerText     = Math.floor(distance_new / (day)).toLocaleString(undefined,{minimumIntegerDigits: 2})+" : ",
                    // countDownHours.innerText    = Math.floor((distance_new % (day)) / (hour)).toLocaleString(undefined,{minimumIntegerDigits: 2})+" : ",
                    // countDownMinutes.innerText  = Math.floor((distance_new % (hour)) / (minute)).toLocaleString(undefined,{minimumIntegerDigits: 2})+" : ",
                    // countDownSeconds.innerText  = Math.floor((distance_new % (minute)) / second).toLocaleString(undefined,{minimumIntegerDigits: 2});
                }

                //do something later when date is reached
                if (distance_new < 0) {
                    var headline  = document.getElementById("ays-chart-countdown-headline"),
                        countdown = document.getElementById("ays-chart-countdown"),
                        content   = document.getElementById("ays-chart-countdown-content");

                  // headline.innerText = "Sale is over!";
                  countdown.style.display = "none";
                  content.style.display = "block";

                  clearInterval(y);
                }
            }, 1000);
        }

		Date.prototype.aysChartCustomFormat = function( formatString){
			var YYYY,YY,MMMM,MMM,MM,M,DDDD,DDD,DD,D,hhhh,hhh,hh,h,mm,m,ss,s,ampm,AMPM,dMod,th;
			YY = ((YYYY=this.getFullYear())+"").slice(-2);
			MM = (M=this.getMonth()+1)<10?('0'+M):M;
			MMM = (MMMM=["January","February","March","April","May","June","July","August","September","October","November","December"][M-1]).substring(0,3);
			DD = (D=this.getDate())<10?('0'+D):D;
			DDD = (DDDD=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"][this.getDay()]).substring(0,3);
			th=(D>=10&&D<=20)?'th':((dMod=D%10)==1)?'st':(dMod==2)?'nd':(dMod==3)?'rd':'th';
			formatString = formatString.replace("#YYYY#",YYYY).replace("#YY#",YY).replace("#MMMM#",MMMM).replace("#MMM#",MMM).replace("#MM#",MM).replace("#M#",M).replace("#DDDD#",DDDD).replace("#DDD#",DDD).replace("#DD#",DD).replace("#D#",D).replace("#th#",th);
			h=(hhh=this.getHours());
			if (h==0) h=24;
			if (h>12) h-=12;
			hh = h<10?('0'+h):h;
			hhhh = hhh<10?('0'+hhh):hhh;
			AMPM=(ampm=hhh<12?'am':'pm').toUpperCase();
			mm=(m=this.getMinutes())<10?('0'+m):m;
			ss=(s=this.getSeconds())<10?('0'+s):s;
	
			return formatString.replace("#hhhh#",hhhh).replace("#hhh#",hhh).replace("#hh#",hh).replace("#h#",h).replace("#mm#",mm).replace("#m#",m).replace("#ss#",ss).replace("#s#",s).replace("#ampm#",ampm).replace("#AMPM#",AMPM);
			// token:     description:             example:
			// #YYYY#     4-digit year             1999
			// #YY#       2-digit year             99
			// #MMMM#     full month name          February
			// #MMM#      3-letter month name      Feb
			// #MM#       2-digit month number     02
			// #M#        month number             2
			// #DDDD#     full weekday name        Wednesday
			// #DDD#      3-letter weekday name    Wed
			// #DD#       2-digit day number       09
			// #D#        day number               9
			// #th#       day ordinal suffix       nd
			// #hhhh#     2-digit 24-based hour    17
			// #hhh#      military/24-based hour   17
			// #hh#       2-digit hour             05
			// #h#        hour                     5
			// #mm#       2-digit minute           07
			// #m#        minute                   7
			// #ss#       2-digit second           09
			// #s#        second                   9
			// #ampm#     "am" or "pm"             pm
			// #AMPM#     "AM" or "PM"             PM
		};

	});

})(jQuery);